package com.biz.crm.checkin.service;

import com.biz.crm.checkin.model.SfaCheckInGroupEntity;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInGroupReqVo;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInGroupSaveReqVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInGroupRespVo;

/**
 * 签到组;接口
 *
 * @author 任钢
 * @date 2021-01-04 14:18:34
 */
public interface ISfaCheckInGroupService extends IService<SfaCheckInGroupEntity> {

    /**
     * 列表
     * @param sfaCheckInGroupReqVo
     * @return PageResult<SfaCheckInGroupRespVo>
     */
    PageResult<SfaCheckInGroupRespVo> findList(SfaCheckInGroupReqVo sfaCheckInGroupReqVo);
    PageResult<SfaCheckInGroupRespVo> myCheckInGroup(SfaCheckInGroupReqVo reqVo);

    /**
     * 查询
     * @param id
     * @return SfaCheckInGroupRespVo
     */
    SfaCheckInGroupRespVo query(String id);

    /**
     * 根据签到组code获取签到组信息
     * @param groupCode
     * @return
     */
    SfaCheckInGroupRespVo getByGroupCode(String groupCode);

    /**
     * 新增or编辑
     * @param sfaCheckInGroupReqVo
     * @return
     */
    void save(SfaCheckInGroupSaveReqVo sfaCheckInGroupReqVo);

    /**
     * 删除
     * @param sfaCheckInGroupReqVo
     * @return
     */
    void deleteBatch(SfaCheckInGroupReqVo sfaCheckInGroupReqVo);

    /**
     * 启用
     * @param sfaCheckInGroupReqVo
     * @return
     */
    void enableBatch(SfaCheckInGroupReqVo sfaCheckInGroupReqVo);

    /**
     * 禁用
     * @param sfaCheckInGroupReqVo
     * @return
     */
    void disableBatch(SfaCheckInGroupReqVo sfaCheckInGroupReqVo);
}

