package com.biz.crm.checkin.service;

import com.biz.crm.checkin.model.SfaCheckInOrgEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInOrgReqVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInOrgRespVo;

/**
 * 签到组织;接口
 *
 * @author 任钢
 * @date 2021-01-04 14:18:34
 */
public interface ISfaCheckInOrgService extends IService<SfaCheckInOrgEntity> {

    /**
     * 列表
     * @param sfaCheckInOrgReqVo
     * @return PageResult<SfaCheckInOrgRespVo>
     */
    PageResult<SfaCheckInOrgRespVo> findList(SfaCheckInOrgReqVo sfaCheckInOrgReqVo);

    /**
     * 查询
     * @param sfaCheckInOrgReqVo
     * @return SfaCheckInOrgRespVo
     */
    SfaCheckInOrgRespVo query(SfaCheckInOrgReqVo sfaCheckInOrgReqVo);

    /**
     * 新增
     * @param sfaCheckInOrgReqVo
     * @return
     */
    void save(SfaCheckInOrgReqVo sfaCheckInOrgReqVo);

    /**
     * 更新
     * @param sfaCheckInOrgReqVo
     * @return
     */
    void update(SfaCheckInOrgReqVo sfaCheckInOrgReqVo);

    /**
     * 删除
     * @param sfaCheckInOrgReqVo
     * @return
     */
    void deleteBatch(SfaCheckInOrgReqVo sfaCheckInOrgReqVo);

    /**
     * 启用
     * @param sfaCheckInOrgReqVo
     * @return
     */
    void enableBatch(SfaCheckInOrgReqVo sfaCheckInOrgReqVo);

    /**
     * 禁用
     * @param sfaCheckInOrgReqVo
     * @return
     */
    void disableBatch(SfaCheckInOrgReqVo sfaCheckInOrgReqVo);

    /**
     * 根据签到组编码删除
     * @param groupCode
     */
    void deleteByGroupCode(String groupCode);
}

