package com.biz.crm.checkin.service;

import com.biz.crm.checkin.model.SfaCheckInSignGroupReportEntity;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.checkin.model.SfaCheckInSignRecordEntity;
import com.biz.crm.eunm.YesNoEnum;

/**
 * 签到组-签到图片接口
 *
 * @author fily
 * @date 2021-01-05 13:12:39
 */
public interface ISfaCheckInSignGroupReportService extends IService<SfaCheckInSignGroupReportEntity> {

    /**
     * 刷新统计信息
     * @param groupCode 签到组编码
     */
    void refreshReport(String groupCode);

    /**
     * 刷新用户的统计信息
     */
    void refreshReportByUserName(SfaCheckInSignRecordEntity sfaCheckInSignRecordEntity, YesNoEnum.yesNoEnum yesNoEnum);


    /**
     * 生成当天的签到组明细——用于定时任务
     * @method timedTaskReport
     * @date: 2021/3/1 17:45
     * @author: YuanZiJian
     * @return void
     */
    void timedTaskReport();

}

