package com.biz.crm.checkin.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInDateReqVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInDateRespVo;
import com.biz.crm.util.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.checkin.model.SfaCheckInDateEntity;
import com.biz.crm.checkin.mapper.SfaCheckInDateMapper;
import com.biz.crm.checkin.service.ISfaCheckInDateService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 签到组-签到日期;接口实现
 *
 * @author 任钢
 * @date 2021-01-04 14:18:34
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaCheckInDateServiceExpandImpl")
public class SfaCheckInDateServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaCheckInDateMapper, SfaCheckInDateEntity> implements ISfaCheckInDateService {

    @Resource
    private SfaCheckInDateMapper sfaCheckInDateMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaCheckInDateRespVo> findList(SfaCheckInDateReqVo reqVo){
        Page<SfaCheckInDateEntity> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        LambdaQueryWrapper<SfaCheckInDateEntity> queryWrapper = Wrappers.lambdaQuery(SfaCheckInDateEntity.class);
        //模糊查询条件封装
        if(StringUtils.isNotEmpty(reqVo.getGroupCode())){
            queryWrapper.eq(SfaCheckInDateEntity::getGroupCode,reqVo.getGroupCode());
        }
        Page<SfaCheckInDateEntity> entityPage = sfaCheckInDateMapper.selectPage(page, queryWrapper);
        List<SfaCheckInDateRespVo> list =CrmBeanUtil.copyList(entityPage.getRecords(),SfaCheckInDateRespVo.class);
        return PageResult.<SfaCheckInDateRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaCheckInDateRespVo
     */
    @Override
    public SfaCheckInDateRespVo query(SfaCheckInDateReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaCheckInDateReqVo reqVo){
        SfaCheckInDateEntity entity = CrmBeanUtil.copy(reqVo,SfaCheckInDateEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaCheckInDateReqVo reqVo){
        SfaCheckInDateEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaCheckInDateReqVo reqVo){
        List<SfaCheckInDateEntity> sfaCheckInDateEntities = sfaCheckInDateMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaCheckInDateEntities)){
            sfaCheckInDateEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaCheckInDateEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaCheckInDateReqVo reqVo){
        //设置状态为启用
        List<SfaCheckInDateEntity> sfaCheckInDateEntities = sfaCheckInDateMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaCheckInDateEntities)){
            sfaCheckInDateEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaCheckInDateEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaCheckInDateReqVo reqVo){
        //设置状态为禁用
        List<SfaCheckInDateEntity> sfaCheckInDateEntities = sfaCheckInDateMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaCheckInDateEntities)){
                sfaCheckInDateEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaCheckInDateEntities);
    }

    /**
     *
     * @param groupCode
     */
    @Override
    public void deleteByGroupCode(String groupCode) {
        sfaCheckInDateMapper.delete(Wrappers.lambdaQuery(SfaCheckInDateEntity.class).eq(SfaCheckInDateEntity::getGroupCode, groupCode));
    }
}
