package com.biz.crm.checkin.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInOrgReqVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInOrgRespVo;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.checkin.model.SfaCheckInOrgEntity;
import com.biz.crm.checkin.mapper.SfaCheckInOrgMapper;
import com.biz.crm.checkin.service.ISfaCheckInOrgService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import javax.annotation.Resource;

/**
 * 签到组织;接口实现
 *
 * @author 任钢
 * @date 2021-01-04 14:18:34
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaCheckInOrgServiceExpandImpl")
public class SfaCheckInOrgServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaCheckInOrgMapper, SfaCheckInOrgEntity> implements ISfaCheckInOrgService {

    @Resource
    private SfaCheckInOrgMapper sfaCheckInOrgMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaCheckInOrgRespVo> findList(SfaCheckInOrgReqVo reqVo){
        Page<SfaCheckInOrgRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaCheckInOrgRespVo> list = sfaCheckInOrgMapper.findList(page, reqVo);
        return PageResult.<SfaCheckInOrgRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaCheckInOrgRespVo
     */
    @Override
    public SfaCheckInOrgRespVo query(SfaCheckInOrgReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaCheckInOrgReqVo reqVo){
        SfaCheckInOrgEntity entity = CrmBeanUtil.copy(reqVo,SfaCheckInOrgEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaCheckInOrgReqVo reqVo){
        SfaCheckInOrgEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaCheckInOrgReqVo reqVo){
        List<SfaCheckInOrgEntity> sfaCheckInOrgEntities = sfaCheckInOrgMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaCheckInOrgEntities)){
            sfaCheckInOrgEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaCheckInOrgEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaCheckInOrgReqVo reqVo){
        //设置状态为启用
        List<SfaCheckInOrgEntity> sfaCheckInOrgEntities = sfaCheckInOrgMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaCheckInOrgEntities)){
            sfaCheckInOrgEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaCheckInOrgEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaCheckInOrgReqVo reqVo){
        //设置状态为禁用
        List<SfaCheckInOrgEntity> sfaCheckInOrgEntities = sfaCheckInOrgMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaCheckInOrgEntities)){
                sfaCheckInOrgEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaCheckInOrgEntities);
    }

    /**
     * 根据签到组编码删除
     * @param groupCode
     */
    @Override
    public void deleteByGroupCode(String groupCode) {
        sfaCheckInOrgMapper.delete(Wrappers.lambdaQuery(SfaCheckInOrgEntity.class).eq(SfaCheckInOrgEntity::getGroupCode, groupCode));
    }
}
