package com.biz.crm.collection.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.collection.service.ISfaDirectoryInputService;
import com.biz.crm.nebular.sfa.collection.resp.SfaDirectoryInputRespVo;
import com.biz.crm.nebular.sfa.collection.req.SfaDirectoryInputReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 拜访步骤 -控件目录信息明细 
 *
 * @author liuhongming
 * @date 2020-09-18 10:33:33
 */
@Slf4j
@RestController
@RequestMapping("/sfaDirectoryInputController")
@Api(tags = "拜访步骤 -控件目录信息明细 ")
public class SfaDirectoryInputController {
    @Autowired
    private ISfaDirectoryInputService sfaDirectoryInputService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaDirectoryInputRespVo>> list(@RequestBody SfaDirectoryInputReqVo sfaDirectoryInputReqVo) {
        PageResult<SfaDirectoryInputRespVo> result=sfaDirectoryInputService.findList(sfaDirectoryInputReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaDirectoryInputRespVo> query(@RequestBody SfaDirectoryInputReqVo sfaDirectoryInputReqVo) {
        SfaDirectoryInputRespVo respVo=sfaDirectoryInputService.query(sfaDirectoryInputReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaDirectoryInputReqVo sfaDirectoryInputReqVo) {
        sfaDirectoryInputService.save(sfaDirectoryInputReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaDirectoryInputReqVo sfaDirectoryInputReqVo) {
        sfaDirectoryInputService.update(sfaDirectoryInputReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaDirectoryInputReqVo sfaDirectoryInputReqVo) {
        sfaDirectoryInputService.deleteBatch(sfaDirectoryInputReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaDirectoryInputReqVo sfaDirectoryInputReqVo) {
        sfaDirectoryInputService.enableBatch(sfaDirectoryInputReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaDirectoryInputReqVo sfaDirectoryInputReqVo) {
        sfaDirectoryInputService.disableBatch(sfaDirectoryInputReqVo);
        return Result.ok("禁用成功");
    }
}
