package com.biz.crm.collection.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.collection.service.ISfaVisitRoleDirectoryService;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleConfigReqVo;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleDirectoryReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleDirectoryRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 拜访步骤配置(角色)--拜访步骤表单配置 
 *
 * @author liuhongming
 * @date 2020-09-18 14:49:32
 */
@Slf4j
@RestController
@RequestMapping("/sfaVisitRoleDirectoryController")
@Api(tags = "拜访步骤配置(角色)--拜访步骤表单配置 ")
public class SfaVisitRoleDirectoryController {
    @Autowired
    private ISfaVisitRoleDirectoryService sfaVisitRoleDirectoryService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<SfaVisitRoleDirectoryRespVo>> list(@RequestBody SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo) {
        PageResult<SfaVisitRoleDirectoryRespVo> result=sfaVisitRoleDirectoryService.findList(sfaVisitRoleDirectoryReqVo);
        return Result.ok(result);
    }


    /**
     * 列表
     */
    @ApiOperation(value = "查询拜访步骤列表")
    @PostMapping("/findRoleDirectoryList")
    @CrmLog
    @CrmDictMethod
    public Result<List<SfaVisitRoleDirectoryRespVo>> findRoleDirectoryList(@RequestBody SfaVisitRoleConfigReqVo reqVo) {
        List<SfaVisitRoleDirectoryRespVo> result=sfaVisitRoleDirectoryService.findRoleDirectoryList(reqVo);
        return Result.ok(result);
    }



    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaVisitRoleDirectoryRespVo> query(@RequestBody SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo) {
        SfaVisitRoleDirectoryRespVo respVo=sfaVisitRoleDirectoryService.query(sfaVisitRoleDirectoryReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo) {
        sfaVisitRoleDirectoryService.save(sfaVisitRoleDirectoryReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo) {
        sfaVisitRoleDirectoryService.update(sfaVisitRoleDirectoryReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        sfaVisitRoleDirectoryService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        sfaVisitRoleDirectoryService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        sfaVisitRoleDirectoryService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
