package com.biz.crm.collection.controller.resp;

import com.biz.crm.base.CrmAttachment;
import com.biz.crm.nebular.mdm.ExtTenVo;
import com.biz.crm.visitstep.resp.SfaVisitStepFromRespVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Data
@ApiModel(value = "拜访执行-步骤")
public class VisitStepResp extends BaseVisitStepResp{

    @ApiModelProperty("有效期类型")
    private String timeType;

    @ApiModelProperty("有效期开始")
    private String startTime;

    @ApiModelProperty("有效期结束")
    private String endTime;

    @ApiModelProperty("排列顺序")
    private Integer sort;

    @ApiModelProperty("步骤执行数据")
    private Object data;

    public static VisitStepResp build(String stepName, String pageCode, String formId, Object data){
        VisitStepResp visitStepResp = new VisitStepResp();
        visitStepResp.setStepName(stepName);
        visitStepResp.setPageCode(pageCode);
        visitStepResp.setFormId(formId);
        visitStepResp.setData(data);
        return visitStepResp;
    }
    public static VisitStepResp build(VisitStepResp stepResp){
        VisitStepResp visitStepResp = build(stepResp.getStepName(), stepResp.getPageCode(), stepResp.getFormId(), null);
        visitStepResp.setIcon(stepResp.getIcon());
        visitStepResp.setIsSuccess(stepResp.getIsSuccess());
        visitStepResp.setIsSuccessDesc(stepResp.getIsSuccessDesc());
        visitStepResp.setDoNot(stepResp.getDoNot());
        visitStepResp.setDoNotDesc(stepResp.getDoNotDesc());
        visitStepResp.setStepCode(stepResp.getStepCode());
        return visitStepResp;
    }
    @Data
    @ApiModel(value = "拜访执行-进离店数据")
    public static class InOutData extends ExtTenVo{
        @ApiModelProperty("打卡时间")
        private String storeDateTime;

        @ApiModelProperty("定位地址")
        private String storeAddress;

        @ApiModelProperty("经度")
        private BigDecimal storeLongitude;

        @ApiModelProperty("纬度")
        private BigDecimal storeLatitude;

        @ApiModelProperty("表单配置")
        private SfaVisitStepFromRespVo sfaVisitStepFrom;

        //进店照片
        @ApiModelProperty("进店照片")
        private List<CrmAttachment> storePics;
    }
    @Data
    @ApiModel(value = "拜访执行-拜访总结数据")
    public static class SummaryData extends ExtTenVo {
        @ApiModelProperty("拜访总结")
        private String visitSummary;

        @ApiModelProperty("拜访汇总")
        private Map<String,String> visitDetailStep;

        @ApiModelProperty("表单配置")
        private SfaVisitStepFromRespVo sfaVisitStepFrom;
    }
}
