package com.biz.crm.collection.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.collection.controller.resp.VisitStepResp;
import com.biz.crm.collection.model.SfaVisitRoleDirectoryEntity;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleConfigReqVo;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleDirectoryReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleDirectoryRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 拜访步骤配置(角色)--拜访步骤表单配置 
 * 
 * @author liuhongming
 * @date 2020-09-18 14:49:32
 */
public interface SfaVisitRoleDirectoryMapper extends BaseMapper<SfaVisitRoleDirectoryEntity> {
    /**
     * 列表
     * @param page
     * @param sfaVisitRoleDirectoryReqVo
     * @return
     */
    List<SfaVisitRoleDirectoryRespVo> findList(Page<SfaVisitRoleDirectoryRespVo> page, @Param("vo") SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo);

    /**
     * 删除
     * @param sfaVisitRoleDirectoryReqVo
     */
    void deleteProductsByParams(@Param("vo") SfaVisitRoleDirectoryReqVo sfaVisitRoleDirectoryReqVo);

    /**
     * 通过角色编码查询拜访步骤
     * @return
     */
    List<SfaVisitRoleDirectoryRespVo> findRoleDirectoryListByRoleList(@Param("visitType") String visitType, @Param("sfacusType") String sfacusType, @Param("roleCodeList")List<String> roleCodeList);

    /**
     * 通过角色编码查询拜访步骤
     * @return
     */
    List<VisitStepResp> findRoleVisitSteps(@Param("visitType") String visitType, @Param("sfacusType") List<String> sfacusType, @Param("roleCodeList")List<String> roleCodeList, @Param("clientSubclassList")List<String> clientSubclassList);

}
