package com.biz.crm.collection.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 拜访步骤表单配置 实体类
 *
 * @author liuhongming
 * @date 2020-09-18 10:33:32
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_directory_config")
@CrmTable(name = "sfa_directory_config", tableNote = "拜访步骤表单配置")
public class SfaDirectoryConfigEntity extends CrmExtTenEntity<SfaDirectoryConfigEntity> {

    /**
     * 步骤编码 步骤编码
     */
    @CrmColumn(name = "directory_code", length = 32, note = "步骤编码 步骤编码")
    private String directoryCode;

    /**
     * 步骤名称 步骤名称
     */
    @CrmColumn(name = "directory_name", length = 100, note = "步骤名称 步骤名称")
    private String directoryName;

    /**
     * 拜访类型 拜访类型
     */
    @CrmColumn(name = "visit_type", length = 32, note = "拜访类型 拜访类型")
    private String visitType;

    /**
     * 客户类型 客户类型
     */
    @CrmColumn(name = "sfacus_type", length = 32, note = "客户类型 客户类型")
    private String sfacusType;

    /**
     * 有效开始时间 有效开始时间
     */
    @CrmColumn(name = "begin_date", length = 32, note = "有效开始时间 有效开始时间")
    private String beginDate;

    /**
     * 有效结束时间 有效结束时间
     */
    @CrmColumn(name = "end_date", length = 32, note = "有效结束时间 有效结束时间")
    private String endDate;

}
