package com.biz.crm.collection.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;

/**
 * 拜访步骤配置(角色) 实体类
 *
 * @author liuhongming
 * @date 2020-09-18 14:49:32
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_visit_role_config")
@CrmTable(name = "sfa_visit_role_config", tableNote = "拜访步骤配置(角色) ",indexes = {
        @Index(name = "sfa_visit_role_config_index1",columnList = "VISIT_ROLE_CODE"),
        @Index(name = "sfa_visit_role_config_index2",columnList = "role_code, visit_type")
})
public class SfaVisitRoleConfigEntity extends CrmExtTenEntity<SfaVisitRoleConfigEntity> {

    /**
     * 拜访步骤配置(角色)编码
     */
    @CrmColumn(name = "visit_role_code", length = 32, note = "拜访步骤配置(角色)编码")
    private String visitRoleCode;
    /**
     * 角色编码 角色编码
     */
    @CrmColumn(name = "role_code", length = 32, note = "角色编码")
    private String roleCode;

    /**
     * 角色名称 角色名称
     */
    @CrmColumn(name = "role_name", length = 100, note = "角色名称")
    private String roleName;

    /**
     * 拜访类型 拜访类型
     */
    @CrmColumn(name = "visit_type", length = 32, note = "拜访类型")
    private String visitType;

    /**
     * 客户类型 客户类型
     */
    @CrmColumn(name = "sfacus_type", length = 32, note = "客户类型")
    private String sfacusType;

    @CrmColumn(name = "sfacus_type_name", length = 32, note = "客户类型")
    private String sfacusTypeName;

    @CrmColumn(name = "client_subclass", length = 32, note = "客户细类")
    private String clientSubclass;

    @CrmColumn(name = "client_subclass_name", length = 32, note = "客户细类")
    private String clientSubclassName;

    @CrmColumn(name = "is_off_line",length = 2,note = "是否离线操作")
    private String isOffLine;
}
