package com.biz.crm.collection.service;

import com.biz.crm.collection.model.SfaDirectoryConfigEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.collection.resp.SfaDirectoryConfigRespVo;
import com.biz.crm.nebular.sfa.collection.req.SfaDirectoryConfigReqVo;

import java.util.Map;

/**
 * 拜访步骤表单配置 接口
 *
 * @author liuhongming
 * @date 2020-09-18 10:33:32
 */
public interface ISfaDirectoryConfigService extends IService<SfaDirectoryConfigEntity> {

    /**
     * 列表
     * @param sfaDirectoryConfigReqVo
     * @return PageResult<SfaDirectoryConfigRespVo>
     */
    PageResult<SfaDirectoryConfigRespVo> findList(SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo);

    /**
     * 查询
     * @param sfaDirectoryConfigReqVo
     * @return SfaDirectoryConfigRespVo
     */
    SfaDirectoryConfigRespVo query(SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo);

    /**
     * 新增
     * @param sfaDirectoryConfigReqVo
     * @return
     */
    void save(SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo);

    /**
     * 更新
     * @param sfaDirectoryConfigReqVo
     * @return
     */
    void update(SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo);

    /**
     * 删除
     * @param sfaDirectoryConfigReqVo
     * @return
     */
    void deleteBatch(SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo);

    /**
     * 启用
     * @param sfaDirectoryConfigReqVo
     * @return
     */
    void enableBatch(SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo);

    /**
     * 禁用
     * @param sfaDirectoryConfigReqVo
     * @return
     */
    void disableBatch(SfaDirectoryConfigReqVo sfaDirectoryConfigReqVo);
}

