package com.biz.crm.collection.service;

import com.biz.crm.collection.model.SfaDirectoryInputEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.collection.resp.SfaDirectoryInputRespVo;
import com.biz.crm.nebular.sfa.collection.req.SfaDirectoryInputReqVo;

import java.util.Map;

/**
 * 拜访步骤 -控件目录信息明细 接口
 *
 * @author liuhongming
 * @date 2020-09-18 10:33:33
 */
public interface ISfaDirectoryInputService extends IService<SfaDirectoryInputEntity> {

    /**
     * 列表
     * @param sfaDirectoryInputReqVo
     * @return PageResult<SfaDirectoryInputRespVo>
     */
    PageResult<SfaDirectoryInputRespVo> findList(SfaDirectoryInputReqVo sfaDirectoryInputReqVo);

    /**
     * 查询
     * @param sfaDirectoryInputReqVo
     * @return SfaDirectoryInputRespVo
     */
    SfaDirectoryInputRespVo query(SfaDirectoryInputReqVo sfaDirectoryInputReqVo);

    /**
     * 新增
     * @param sfaDirectoryInputReqVo
     * @return
     */
    void save(SfaDirectoryInputReqVo sfaDirectoryInputReqVo);

    /**
     * 更新
     * @param sfaDirectoryInputReqVo
     * @return
     */
    void update(SfaDirectoryInputReqVo sfaDirectoryInputReqVo);

    /**
     * 删除
     * @param sfaDirectoryInputReqVo
     * @return
     */
    void deleteBatch(SfaDirectoryInputReqVo sfaDirectoryInputReqVo);

    /**
     * 启用
     * @param sfaDirectoryInputReqVo
     * @return
     */
    void enableBatch(SfaDirectoryInputReqVo sfaDirectoryInputReqVo);

    /**
     * 禁用
     * @param sfaDirectoryInputReqVo
     * @return
     */
    void disableBatch(SfaDirectoryInputReqVo sfaDirectoryInputReqVo);
}

