package com.biz.crm.collection.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.collection.model.SfaVisitRoleConfigEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleConfigReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleConfigRespVo;

import java.util.List;

/**
 * 拜访步骤配置(角色) 接口
 *
 * @author liuhongming
 * @date 2020-09-18 14:49:32
 */
public interface ISfaVisitRoleConfigService extends IService<SfaVisitRoleConfigEntity> {

    /**
     * 列表
     * @param sfaVisitRoleConfigReqVo
     * @return PageResult<SfaVisitRoleConfigRespVo>
     */
    PageResult<SfaVisitRoleConfigRespVo> findList(SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo);


    /**
     * 通过id查询详情
     * @param id
     * @return
     */
    SfaVisitRoleConfigRespVo queryDetailById(String id);

    /**
     * 查询
     * @param sfaVisitRoleConfigReqVo
     * @return SfaVisitRoleConfigRespVo
     */
    SfaVisitRoleConfigRespVo query(SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo);

    /**
     * 新增
     * @param sfaVisitRoleConfigReqVo
     * @return
     */
    void save(SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo);

    /**
     * 更新
     * @param sfaVisitRoleConfigReqVo
     * @return
     */
    void update(SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);
}

