package com.biz.crm.collection.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.collection.controller.resp.VisitStepResp;
import com.biz.crm.collection.mapper.SfaVisitRoleConfigMapper;
import com.biz.crm.collection.mapper.SfaVisitRoleDirectoryMapper;
import com.biz.crm.collection.model.SfaVisitRoleConfigEntity;
import com.biz.crm.collection.model.SfaVisitRoleDirectoryEntity;
import com.biz.crm.collection.service.ISfaVisitRoleConfigService;
import com.biz.crm.collection.service.ISfaVisitRoleDirectoryService;
import com.biz.crm.common.PageResult;
import com.biz.crm.common.param.ParameterParam;
import com.biz.crm.enums.SfaVisitRoleEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.eunm.sfa.VisitStepFromEnum;
import com.biz.crm.mdm.role.MdmRoleFeign;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitResp;
import com.biz.crm.nebular.mdm.role.req.MdmUserRoleReqVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.nebular.sfa.collection.req.FindVisitDetailReqVo;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleConfigReqVo;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleDirectoryReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleDirectoryRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.*;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 拜访步骤配置(角色)--拜访步骤表单配置 接口实现
 *
 * @author liuhongming
 * @date 2020-09-18 14:49:32
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "SfaVisitRoleDirectoryServiceExpandImpl")
@Transactional
public class SfaVisitRoleDirectoryServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaVisitRoleDirectoryMapper, SfaVisitRoleDirectoryEntity> implements ISfaVisitRoleDirectoryService {

    @Resource
    private SfaVisitRoleDirectoryMapper sfaVisitRoleDirectoryMapper;
    @Resource
    private MdmRoleFeign mdmRoleFeign;
//    @Resource
//    private Map<String, StepInfoLoader> stringStepInfoLoaderMap;
    @Resource
    private RedisService redisService;
    @Autowired
    private ISfaVisitRoleConfigService sfaVisitRoleConfigService;
    @Resource
    private SfaVisitRoleConfigMapper sfaVisitRoleConfigMapper;

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaVisitRoleDirectoryRespVo> findList(SfaVisitRoleDirectoryReqVo reqVo) {
        Page<SfaVisitRoleDirectoryRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaVisitRoleDirectoryRespVo> list = sfaVisitRoleDirectoryMapper.findList(page, reqVo);
        list.forEach(data -> {
            data.setDoNotDesc(SfaVisitRoleEnum.getSfaVisitRole(data.getDoNot()).getDesc());
        });
        return PageResult.<SfaVisitRoleDirectoryRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询拜访人员拜访步骤列表
     * @param reqVo
     * @return
     */
    @Override
    public List<SfaVisitRoleDirectoryRespVo> findRoleDirectoryList(SfaVisitRoleConfigReqVo reqVo) {
        List<SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryRespVos = new ArrayList<>();
        if (!StringUtils.isNotEmpty(reqVo.getVisitUserName())){
            UserRedis userRedis = UserUtils.getUser();
            reqVo.setVisitUserName(userRedis.getUsername());
            reqVo.setVisitPosCode(userRedis.getPoscode());
        }
        this.checkFindRoleConfigList(reqVo);
        List<String> roleList = ApiResultUtil.objResult(mdmRoleFeign.getRoleByPositionCode(reqVo.getVisitPosCode()),true);
        if (CollectionUtil.listNotEmptyNotSizeZero(roleList)){
            reqVo.setRoleCodeList(roleList);
            List<SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryRespVoList = sfaVisitRoleDirectoryMapper.findRoleDirectoryListByRoleList(reqVo.getVisitType(), reqVo.getSfacusType(), roleList);
            if (CollectionUtil.listNotEmptyNotSizeZero(sfaVisitRoleDirectoryRespVoList)){
                Map<String,List<SfaVisitRoleDirectoryRespVo>> resultMap = sfaVisitRoleDirectoryRespVoList.stream().collect(Collectors.groupingBy(SfaVisitRoleDirectoryRespVo::getDirectoryCode));
                for (Map.Entry<String,List<SfaVisitRoleDirectoryRespVo>> map:resultMap.entrySet()){
                    SfaVisitRoleDirectoryRespVo data = map.getValue().get(0);
                    sfaVisitRoleDirectoryRespVos.add(data);
                }
                sfaVisitRoleDirectoryRespVos = sfaVisitRoleDirectoryRespVos.stream().sorted(Comparator.comparing(SfaVisitRoleDirectoryRespVo::getSort)).collect(Collectors.toList());
            }
        }
        return sfaVisitRoleDirectoryRespVos;
    }
    /**
     * 查询拜访人员拜访步骤列表
     * @return
     */
    private Map<String, SfaVisitRoleDirectoryRespVo> findRoleDirectoryMap(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitEnum.sfaVisitType sfaVisitType) {

        List<String> roleList = this.getPositionRoleList(sfaVisitPlanInfoEntity.getVisitUserName(), sfaVisitPlanInfoEntity.getVisitPosCode());
        if(org.springframework.util.CollectionUtils.isEmpty(roleList)){
            return Maps.newHashMap();
        }
//        List<String> roleCodeList = roleList.stream().map(MdmRoleRespVo :: getRoleCode).collect(Collectors.toList());
//        step_form.id as form_id, step_form.visit_type, step_form.icon, step_form.page_code, step_form.time_type, step_form.start_time, step_form.end_time,
        List<SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryRespVoList = sfaVisitRoleDirectoryMapper.findRoleDirectoryListByRoleList(sfaVisitType.getVal(), sfaVisitPlanInfoEntity.getClientType(), roleList);
        Map<String, SfaVisitRoleDirectoryRespVo> resultMap = sfaVisitRoleDirectoryRespVoList.stream()
                .collect(Collectors.toMap(SfaVisitRoleDirectoryRespVo :: getDirectoryCode, v -> v, (t, t2) -> t2));
        return resultMap;
    }

    /**
     * 查询拜访人员拜访步骤列表
     * @return
     */
    @Override
    @Transactional(readOnly = true)
    public Map<String, VisitStepResp> findRoleVisitStepMap(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity){
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(sfaVisitPlanInfoEntity.getRedisHashKey());
        return this.findRoleVisitStepMap(visitRedisHashKey, sfaVisitPlanInfoEntity.getClientSubclass());
    }
    /**
     * 查询拜访人员拜访步骤列表
     * @return
     */
    @Override
    @Transactional(readOnly = true)
    public Map<String, VisitStepResp> findRoleVisitStepMap(SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey, String clientSubclass) {
        String visitBigType = visitRedisHashKey.getVisitBigType()
                , visitPosCode = visitRedisHashKey.getVisitPosCode()
                , clientType = visitRedisHashKey.getClientType();
        List<String> roleList = this.getPositionRoleList(visitRedisHashKey.getVisitUserName(), visitPosCode);
        if(org.springframework.util.CollectionUtils.isEmpty(roleList)){
            return Maps.newHashMap();
        }
        List<String> clientTypes = null, clientSubclassList = null;
        if(!SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal().equals(visitBigType)){
            clientTypes = Lists.newArrayList(clientType);
            String configRange = ParamUtil.getParameterValue(ParameterParam.SFA_VISIT_STEP_CONFIG_CLIENT_SUBCLASS_RANGE);
            if(YesNoEnum.yesNoEnum.NO.getValue().equals(configRange)){
                clientSubclassList = null;
            }else{
                if (StringUtils.isNotEmpty(clientSubclass)){
                    clientSubclassList = Lists.newArrayList(clientSubclass);
                }
            }
        }

        List<VisitStepResp> visitSteps = sfaVisitRoleDirectoryMapper.findRoleVisitSteps(visitBigType, clientTypes , roleList, clientSubclassList);
        LocalDateTime now = LocalDateTime.now();
        Map<String, VisitStepResp> resultMap = visitSteps.stream().filter(v -> {
                    //过滤 过期步骤表单
                    if(VisitStepFromEnum.timeType.DIY_TIME.getValue().equals(v.getTimeType())
                            && org.apache.commons.lang3.StringUtils.isNotBlank(v.getStartTime())
                            && org.apache.commons.lang3.StringUtils.isNotBlank(v.getEndTime())){
                        //表单已过期
                        if(now.compareTo(LocalDateTime.parse(v.getStartTime() + " " + CrmDateUtils.TIME_STR_00, CrmDateUtils.yyyyMMddHHmmss)) < 0 || now.compareTo(LocalDateTime.parse(v.getEndTime() + " " + CrmDateUtils.TIME_STR_235959, CrmDateUtils.yyyyMMddHHmmss)) > 0){
                            return false;
                        }
                    }
                    return true;
                }).collect(Collectors.toMap(VisitStepResp :: getStepCode, v -> {
                    //翻译
                    v.setIsSuccess(SfaVisitEnum.isSuccess.NOT_SUCCESS.getVal());
                    v.setIsSuccessDesc(SfaVisitEnum.isSuccess.NOT_SUCCESS.getDesc());

                    YesNoEnum.yesNoEnum yesNoEnum = YesNoEnum.yesNoEnum.getEnum(v.getDoNot());
                    if(null != yesNoEnum){
                        v.setDoNotDesc(yesNoEnum.getDes());
                    }
                    return v;
                }, (t, t2) -> {
                    //多个角色配了相同步骤，优先取必填的那个
                    if(YesNoEnum.yesNoEnum.yes.getValue().equals(t.getDoNot())){
                        return t;
                    }
                    return t2;
                }));
        return resultMap;
    }

    @Override
    @Transactional(readOnly = true)
    public void buildSfaVisitPlanInfoFormId(SfaVisitResp.SfaVisitPlanInfoResp visitPlanInfo, String visitPosCode) {
        List<String> clientTypes = Lists.newArrayList(visitPlanInfo.getClientType());
        List<String> clientSubclassList = Lists.newArrayList(visitPlanInfo.getClientSubclass());
        String visitBigType = visitPlanInfo.getVisitBigType();
        Map<String, Map<String, VisitStepResp>> stepRespMap = this.findRoleVisitStepMapForClientTypes(visitPlanInfo.getVisitUserName(), visitPosCode, clientTypes, visitBigType, clientSubclassList);
        visitPlanInfo.buildFormId(stepRespMap);
    }

    /**
     * 查询职位客户类型下的步骤列表
     * @param visitPosCode
     * @param clientTypes
     * @return
     */
    @Override
    @Transactional(readOnly = true)
    public Map<String, Map<String, VisitStepResp>> findRoleVisitStepMapForClientTypes(String visitUserName, String visitPosCode, List<String> clientTypes, String visitBigType, List<String> clientSubclassList) {
        List<String> roleList = this.getPositionRoleList(visitUserName, visitPosCode);
        if(org.springframework.util.CollectionUtils.isEmpty(roleList)){
            return Maps.newHashMap();
        }
        if(SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal().equals(visitBigType)){
            clientTypes = null;
            clientSubclassList = null;
        }
        String configRange = ParamUtil.getParameterValue(ParameterParam.SFA_VISIT_STEP_CONFIG_CLIENT_SUBCLASS_RANGE);
        if(YesNoEnum.yesNoEnum.NO.getValue().equals(configRange)){
            clientSubclassList = null;
        }

        List<VisitStepResp> visitSteps = sfaVisitRoleDirectoryMapper.findRoleVisitSteps(visitBigType, clientTypes, roleList, clientSubclassList);
        Map<String, Map<String, VisitStepResp>> clientTypeMapResult = Maps.newHashMap();
        Map<String, List<VisitStepResp>> clientTypeMap = visitSteps.stream().collect(Collectors.groupingBy(v -> {
            //陌拜固定为终端类型
            if(SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal().equals(visitBigType)){
                return v.getVisitType() + SfaVisitEnum.ClientType.TERMINAL.getVal();
            }
            return v.getVisitType() + v.getClientType();
        }));

        for(Map.Entry<String, List<VisitStepResp>> entry : clientTypeMap.entrySet()){
            Map<String, VisitStepResp> resultMap = entry.getValue().stream()
                    .collect(Collectors.toMap(VisitStepResp :: getStepCode, v -> v, (t, t2) -> t2));
            clientTypeMapResult.put(entry.getKey(), resultMap);
        }

        return clientTypeMapResult;
    }

    protected List<String> getPositionRoleList(String visitUserName, String visitPosCode){
        if(org.apache.commons.lang3.StringUtils.isBlank(visitPosCode)){
            throw new BusinessException("请指定职位编码！");
        }
        MdmUserRoleReqVo mdmUserRoleReqVo = new MdmUserRoleReqVo();
        mdmUserRoleReqVo.setUserName(visitUserName);
        mdmUserRoleReqVo.setPositionCode(visitPosCode);
        List<MdmRoleRespVo> roleList = ApiResultUtil.objResult(mdmRoleFeign.obtainUserRoleList(mdmUserRoleReqVo), true);
        if(null == roleList){
            throw new BusinessException("查询用户角色失败，主数据服务不可用！");
        }
//        MdmPositionRespVo mdmPositionRespVo = PositionUtil.getPositionByCode(sfaVisitPlanInfoEntity.getVisitPosCode());
//        List<MdmRoleRespVo> roleList = mdmPositionRespVo.getRoleList();

//        List<String> roleCodeList = roleList.stream().map(MdmRoleRespVo :: getRoleCode).collect(Collectors.toList());
        return roleList.stream().map(MdmRoleRespVo :: getRoleCode).collect(Collectors.toList());
    }
    /**
     * 查询拜访步骤列表
     * @return
     */
    @Override
    @Transactional(readOnly = true)
    public List<SfaVisitRoleDirectoryRespVo> findVisitRoleDirectoryList(String redisHashKey, String visitBigType) {

        AssertUtils.isNotEmpty(redisHashKey,"拜访redisHashKey为空");
        String dateNow = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)this.redisService
                .hmget(SfaVisitPlanInfoEntity.getInstance().redisHashCurrent(dateNow, visitBigType).toString(), redisHashKey);
        if(null == sfaVisitPlanInfoEntity){
            throw new BusinessException("未查询到拜访计划信息！");
        }
        UserRedis userRedis = UserUtils.getUser();
        if(org.apache.commons.lang3.StringUtils.equals(sfaVisitPlanInfoEntity.getVisitPosCode(), userRedis.getPoscode())){
            throw new BusinessException("你没有权限访问该数据，请重新登陆或切换职位再尝试！");
        }

        Map<String, SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryRespVos = this.findRoleDirectoryMap(sfaVisitPlanInfoEntity, SfaVisitEnum.sfaVisitType.VISIT);

        sfaVisitRoleDirectoryRespVos.remove(SfaVisitEnum.visitStep.VISIT_STEP_IN_STORE.getVal());
        sfaVisitRoleDirectoryRespVos.remove(SfaVisitEnum.visitStep.VISIT_STEP_OUT_STORE.getVal());
        this.buildStepInfo(sfaVisitRoleDirectoryRespVos, redisHashKey);
        List<SfaVisitRoleDirectoryRespVo> dataList = sfaVisitRoleDirectoryRespVos.values().stream().sorted(Comparator.comparing(SfaVisitRoleDirectoryRespVo::getSort)).collect(Collectors.toList());
        return dataList;
    }

    @Override
    @Transactional(readOnly = true)
    public List<VisitStepResp> findVisitRoleDirectoryList(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity) {

        Map<String, VisitStepResp> roleVisitStepMap = this.findRoleVisitStepMap(sfaVisitPlanInfoEntity);
        List<VisitStepResp> dataList = roleVisitStepMap.values().stream().filter(v -> {
            //过滤进店离店步骤(在拜访中时，移动端不展示进离店步骤)
            if(SfaVisitEnum.visitStep.VISIT_STEP_IN_STORE.getVal().equals(v.getPageCode())
                    || SfaVisitEnum.visitStep.VISIT_STEP_OUT_STORE.getVal().equals(v.getPageCode())){
                return false;
            }
            return true;
        }).sorted(Comparator.comparing(VisitStepResp::getSort)).collect(Collectors.toList());
        return dataList;
    }

    /**
     * 查询拜访步骤详情
     * @param findVisitDetailReqVo
     * @return
     */
    @Override
    @Deprecated
    @CrmAPIDiscard
    public List<SfaVisitRoleDirectoryRespVo> findVisitDetail(FindVisitDetailReqVo findVisitDetailReqVo) {
        SfaVisitRoleConfigReqVo reqVo = CrmBeanUtil.copy(findVisitDetailReqVo, SfaVisitRoleConfigReqVo.class);
        AssertUtils.isNotEmpty(reqVo.getVisitId(),"拜访id为空");
        String redisHash = null;
        AssertUtils.isNotEmpty(redisHash,"拜访redisHash为空");

        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)this.redisService.hmget(redisHash);
        UserRedis userRedis = UserUtils.getUser();
        if(org.apache.commons.lang3.StringUtils.equals(sfaVisitPlanInfoEntity.getVisitPosCode(), userRedis.getPoscode())){
            throw new BusinessException("你没有权限访问该数据，请重新登陆或切换职位再尝试！");
        }

        Map<String,SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryRespVos = this.findRoleDirectoryMap(sfaVisitPlanInfoEntity, SfaVisitEnum.sfaVisitType.VISIT);
        this.buildStepInfo(sfaVisitRoleDirectoryRespVos, reqVo.getVisitId());
        List<SfaVisitRoleDirectoryRespVo> dataList = sfaVisitRoleDirectoryRespVos.values().stream().sorted(Comparator.comparing(SfaVisitRoleDirectoryRespVo::getSort)).collect(Collectors.toList());
        return dataList;
    }

    /**
     * 组装拜访步骤信息
     * @param sfaVisitRoleDirectoryRespVos
     * @param redisHashKey
     */
    private void buildStepInfo( Map<String,SfaVisitRoleDirectoryRespVo>  sfaVisitRoleDirectoryRespVos,String redisHashKey){

        sfaVisitRoleDirectoryRespVos.forEach((directoryCode, data) -> {
            data.setIsSuccess(SfaVisitEnum.isSuccess.NOT_SUCCESS.getVal());
            data.setIsSuccessDesc(SfaVisitEnum.isSuccess.NOT_SUCCESS.getDesc());

            YesNoEnum.yesNoEnum yesNoEnum = YesNoEnum.yesNoEnum.getEnum(data.getDoNot());
            if(null != yesNoEnum){
                data.setDoNotDesc(yesNoEnum.getDes());
            }
//            StepInfoLoader stepInfoLoader = this.stringStepInfoLoaderMap.get(directoryCode + StepInfoLoader.componentPostfix);
//            if(null == stepInfoLoader){
//                throw new BusinessException("未找到步骤[" + directoryCode + "]的执行实例，请重试！");
//            }
//            stepInfoLoader.load(data, redisHashKey);
        });
    }

    /**
     * 组装拜访步骤信息
     * @param sfaVisitRoleDirectoryList
     * @param visitId
     */
    private void assembleVisitStep(List<SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryList,String visitId,String yesNo){
//        sfaVisitRoleDirectoryList.forEach(data->{
//            data.setIsSuccess(SfaVisitEnum.isSuccess.NOT_SUCCESS.getVal());
//            data.setIsSuccessDesc(SfaVisitEnum.isSuccess.NOT_SUCCESS.getDesc());
//            //订单采集
//            if (data.getDirectoryCode().equals(SfaVisitEnum.visitStep.VISIT_STEP_ORDER.getVal())){
//                Integer count = sfaVisitStepOrderService.lambdaQuery()
//                        .eq(SfaVisitStepOrderEntity::getVisitId,visitId).count();
//                if (count>0){
//                    data.setIsSuccess(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getVal());
//                    data.setIsSuccessDesc(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getDesc());
//                }
//                if (yesNo.equals(YesNoEnum.YesNoCodeNumberEnum.YES.getValue())){
//                    SfaVisitStepOrderRespVo sfaVisitStepOrderRespVo = sfaVisitStepOrderService.queryDetailByVisitDetailId(visitId);
//                    data.setStepOrder(sfaVisitStepOrderRespVo);
//                }
//            }else if(data.getDirectoryCode().equals(SfaVisitEnum.visitStep.VISIT_STEP_STOCK.getVal())){
//                //库存盘点
//                Integer count = sfaVisitStepStockInventoryService.lambdaQuery()
//                        .eq(SfaVisitStepStockInventoryEntity::getVisitId,visitId).count();
//                if (count>0){
//                    data.setIsSuccess(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getVal());
//                    data.setIsSuccessDesc(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getDesc());
//                }
//                if (yesNo.equals(YesNoEnum.YesNoCodeNumberEnum.YES.getValue())){
//                    List<SfaVisitStepStockInventoryRespVo> sfaVisitStepStockInventoryRespVos = sfaVisitStepStockInventoryService.queryDetailByVisitDetailId(visitId);
//                    data.setStepStockInventoryList(sfaVisitStepStockInventoryRespVos);
//                }
//            }else if(data.getDirectoryCode().equals(SfaVisitEnum.visitStep.VISIT_STEP_DISPLAY.getVal())){
//                //陈列检查
//                Integer count = sfaVisitStepActivityExecutionService.lambdaQuery()
//                        .eq(SfaVisitStepActivityExecutionEntity::getVisitId,visitId)
//                        .eq(SfaVisitStepActivityExecutionEntity::getActivityType, SfaActivityEnum.activityType.DISPLAY_ACTIVITY.getVal()).count();
//                if (count>0){
//                    data.setIsSuccess(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getVal());
//                    data.setIsSuccessDesc(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getDesc());
//                }
//                if (yesNo.equals(YesNoEnum.YesNoCodeNumberEnum.YES.getValue())){
//                    SfaActivityExecutionRespVo sfaActivityExecutionRespVo = sfaVisitStepActivityExecutionService.findVisitDisplayActivityExecutionByVisitId(visitId);
//                    data.setStepCostActivityExecution(sfaActivityExecutionRespVo);
//                }
//            }else if (data.getDirectoryCode().equals(SfaVisitEnum.visitStep.VISIT_STEP_SUMMARY.getVal())){
//                //拜访总结
//                Integer count = sfaVisitDealerDetailService.lambdaQuery()
//                        .eq(SfaVisitDealerDetailEntity::getId,visitId).count();
//                if (count>0){
//                    data.setIsSuccess(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getVal());
//                    data.setIsSuccessDesc(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getDesc());
//                }
//                if (yesNo.equals(YesNoEnum.YesNoCodeNumberEnum.YES.getValue())){
//                    SfaVisitDealerDetailRespVo sfaVisitDealerDetailRespVo = sfaVisitDealerDetailService.findVisitSummaryByVisitId(visitId);
//                    data.setStepSummary(sfaVisitDealerDetailRespVo);
//                }
//            }else if (data.getDirectoryCode().equals(SfaVisitEnum.visitStep.VISIT_STEP_COST.getVal())){
//                //费用活动
//                Integer count = sfaVisitStepActivityExecutionService.lambdaQuery()
//                        .eq(SfaVisitStepActivityExecutionEntity::getVisitId,visitId)
//                        .eq(SfaVisitStepActivityExecutionEntity::getActivityType, SfaActivityEnum.activityType.COST_ACTIVITY.getVal()).count();
//                if (count>0){
//                    data.setIsSuccess(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getVal());
//                    data.setIsSuccessDesc(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getDesc());
//                }
//                if (yesNo.equals(YesNoEnum.YesNoCodeNumberEnum.YES.getValue())){
//                    SfaActivityExecutionRespVo sfaActivityExecutionRespVo = sfaVisitStepActivityExecutionService.findVisitCostActivityExecutionByVisitId(visitId);
//                    data.setStepCostActivityExecution(sfaActivityExecutionRespVo);
//                }
//            }else if (data.getDirectoryCode().equals(SfaVisitEnum.visitStep.VISIT_STEP_TPM.getVal())){
//                //tpm活动
//                Integer count = sfaVisitStepActivityExecutionService.lambdaQuery()
//                        .eq(SfaVisitStepActivityExecutionEntity::getVisitId,visitId)
//                        .eq(SfaVisitStepActivityExecutionEntity::getActivityType, SfaActivityEnum.activityType.COST_ACTIVITY.getVal()).count();
//                if (count>0){
//                    data.setIsSuccess(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getVal());
//                    data.setIsSuccessDesc(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getDesc());
//                }
//                if (yesNo.equals(YesNoEnum.YesNoCodeNumberEnum.YES.getValue())){}
//            }else if (data.getDirectoryCode().equals(SfaVisitEnum.visitStep.VISIT_STEP_COMPETITOR.getVal())){
//                //竞品采集
//                Integer count = sfaVisitStepColletService.lambdaQuery()
//                        .eq(SfaVisitStepColletEntity::getVisitId,visitId).count();
//                if (count>0){
//                    data.setIsSuccess(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getVal());
//                    data.setIsSuccessDesc(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getDesc());
//                }
//                if (yesNo.equals(YesNoEnum.YesNoCodeNumberEnum.YES.getValue())){
//                    SfaVisitStepColletRespVo sfaVisitStepColletRespVo = sfaVisitStepColletService.queryVisitStepColletByVisitId(visitId);
//                    data.setStepCollet(sfaVisitStepColletRespVo);
//                }
//            }else if (data.getDirectoryCode().equals(SfaVisitEnum.visitStep.VISIT_STEP_STORE_CHECK.getVal())){
//                //店面检查
//                Integer count = sfaVisitStepStoreCheckService.lambdaQuery()
//                        .eq(SfaVisitStepStoreCheckEntity::getVisitId,visitId).count();
//                if (count>0){
//                    data.setIsSuccess(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getVal());
//                    data.setIsSuccessDesc(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getDesc());
//                }
//                if (yesNo.equals(YesNoEnum.YesNoCodeNumberEnum.YES.getValue())){
//                    SfaVisitStepStoreCheckRespVo sfaVisitStepStoreCheckRespVo = sfaVisitStepStoreCheckService.findVisitStoreCheckByVisitId(visitId);
//                    data.setStepStoreCheck(sfaVisitStepStoreCheckRespVo);
//                }
//            }else if (data.getDirectoryCode().equals(SfaVisitEnum.visitStep.VISIT_STEP_IN_STORE.getVal())){
//                //进店打卡
//                Integer count = sfaVisitDealerDetailService.lambdaQuery()
//                        .eq(SfaVisitDealerDetailEntity::getId,visitId)
//                        .isNotNull(SfaVisitDealerDetailEntity::getInStore).count();
//                if (count>0){
//                    data.setIsSuccess(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getVal());
//                    data.setIsSuccessDesc(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getDesc());
//                }
//                if (yesNo.equals(YesNoEnum.YesNoCodeNumberEnum.YES.getValue())){
//                    SfaVisitDealerDetailRespVo sfaVisitDealerDetailRespVo = sfaVisitDealerDetailService.findVisitInStoreByVisitId(visitId);
//                    data.setStepInStore(sfaVisitDealerDetailRespVo);
//                }
//            }else if (data.getDirectoryCode().equals(SfaVisitEnum.visitStep.VISIT_STEP_OUT_STORE.getVal())){
//                //离店打卡
//                Integer count = sfaVisitDealerDetailService.lambdaQuery()
//                        .eq(SfaVisitDealerDetailEntity::getId,visitId)
//                        .isNotNull(SfaVisitDealerDetailEntity::getOutStore).count();
//                if (count>0){
//                    data.setIsSuccess(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getVal());
//                    data.setIsSuccessDesc(SfaVisitEnum.isSuccess.ALREADY_SUCCESS.getDesc());
//                }
//                if (yesNo.equals(YesNoEnum.YesNoCodeNumberEnum.YES.getValue())){
//                    SfaVisitDealerDetailRespVo sfaVisitDealerDetailRespVo = sfaVisitDealerDetailService.findVisitOutStoreByVisitId(visitId);
//                    data.setStepOutStore(sfaVisitDealerDetailRespVo);
//                }
//            }
//        });
    }

    /**
     * 检查参数信息
     * @param reqVo
     */
    private void checkFindRoleConfigList(SfaVisitRoleConfigReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getVisitPosCode(),"职位编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getVisitUserName(),"人员账号不能为空");
        AssertUtils.isNotEmpty(reqVo.getSfacusType(),"客户类型不能为空");
        AssertUtils.isNotEmpty(reqVo.getVisitType(),"拜访类型不能为空");
    }

    /**
     * 查询
     *
     * @param reqVo
     * @return sfaVisitRoleDirectoryRespVo
     */
    @Override
    public SfaVisitRoleDirectoryRespVo query(SfaVisitRoleDirectoryReqVo reqVo) {
        return null;
    }

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaVisitRoleDirectoryReqVo reqVo) {
        SfaVisitRoleDirectoryEntity entity = CrmBeanUtil.copy(reqVo, SfaVisitRoleDirectoryEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    public void update(SfaVisitRoleDirectoryReqVo reqVo) {
        SfaVisitRoleDirectoryEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @Override
    public void deleteBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("数据主键不能为空");
        }
        List<SfaVisitRoleDirectoryEntity> sfaVisitRoleDirectoryEntities = sfaVisitRoleDirectoryMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(sfaVisitRoleDirectoryEntities)) {
            sfaVisitRoleDirectoryEntities.forEach(o -> {
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaVisitRoleDirectoryEntities);
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @Override
    public void enableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("数据主键不能为空");
        }
        //设置状态为启用
        List<SfaVisitRoleDirectoryEntity> sfaVisitRoleDirectoryEntities = sfaVisitRoleDirectoryMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(sfaVisitRoleDirectoryEntities)) {
            sfaVisitRoleDirectoryEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitRoleDirectoryEntities);
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @Override
    public void disableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("数据主键不能为空");
        }
        //设置状态为禁用
        List<SfaVisitRoleDirectoryEntity> sfaVisitRoleDirectoryEntities = sfaVisitRoleDirectoryMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(sfaVisitRoleDirectoryEntities)) {
            sfaVisitRoleDirectoryEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaVisitRoleDirectoryEntities);
    }

    @Override
    public String findRoleStepIsOffLine(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity) {
        SfaVisitPlanInfoEntity.VisitRedisHashKey visitRedisHashKey = new SfaVisitPlanInfoEntity.VisitRedisHashKey(sfaVisitPlanInfoEntity.getRedisHashKey());
        List<String> roleList = this.getPositionRoleList(visitRedisHashKey.getVisitUserName(),visitRedisHashKey.getVisitPosCode());
        String visitBigType = visitRedisHashKey.getVisitBigType();
        List<String> clientSubclassList = null;
        if(!SfaVisitEnum.VisitBigType.UNFAMILIAR_VISIT.getVal().equals(visitBigType)){
            String configRange = ParamUtil.getParameterValue(ParameterParam.SFA_VISIT_STEP_CONFIG_CLIENT_SUBCLASS_RANGE);
            if(YesNoEnum.yesNoEnum.NO.getValue().equals(configRange)){
                clientSubclassList = null;
            }else{
                clientSubclassList = Lists.newArrayList(sfaVisitPlanInfoEntity.getClientSubclass());
            }
        }
        List<SfaVisitRoleConfigEntity> roleConfigEntities = sfaVisitRoleConfigService.lambdaQuery()
                .in(SfaVisitRoleConfigEntity::getRoleCode,roleList)
                .eq(SfaVisitRoleConfigEntity::getVisitType,visitRedisHashKey.getVisitBigType())
                .eq(SfaVisitRoleConfigEntity::getSfacusType,visitRedisHashKey.getClientType())
                .eq(SfaVisitRoleConfigEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode())
                .eq(SfaVisitRoleConfigEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode())
                .in(CollectionUtil.listNotEmptyNotSizeZero(clientSubclassList),SfaVisitRoleConfigEntity::getClientSubclass,clientSubclassList)
                .list();
        if (CollectionUtil.listNotEmptyNotSizeZero(roleConfigEntities)){
            List<String> isOffLineList = roleConfigEntities.stream().filter(data->YesNoEnum.yesNoEnum.YES.getValue().equals(data.getIsOffLine()))
                    .map(SfaVisitRoleConfigEntity::getIsOffLine).collect(Collectors.toList());
            if (CollectionUtil.listNotEmptyNotSizeZero(isOffLineList)){
                return YesNoEnum.yesNoEnum.YES.getValue();
            }
            return YesNoEnum.yesNoEnum.NO.getValue();
        }else {
            return YesNoEnum.yesNoEnum.NO.getValue();
        }
    }
}
