package com.biz.crm.customer.controller;

import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepListener;
import com.google.common.collect.Sets;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * 客户业务动态监听器
 * @author yangshan
 * @date 2021/4/9 14:30
 */
@Component
public class SfaBusinessDetailListener extends AbstractVisitStepListener {

    /**
     * 拜访步骤监听器注册，
     * 请返回该步骤监听器对应的拜访步骤编码[SfaCodeEnum.VisitStepCode]
     * 如果需要监听全部大类，则返回 SfaVisitEnum.VisitStepCode.LISTENER_ALL
     * @return
     */
    @Override
    protected Set<String> visitStepCodeRegistry() {
        return Sets.newHashSet(SfaCodeEnum.VisitStepCode.LISTENER_ALL);
    }

    /**
     *  ############## 该事件还未触发,后期实现 ##############
     * 拜访执行，用户有可能反复编辑后提交多次，生成多个事件。
     * 该事件的业务数据完全在redis缓存里操作，不会持久化到数据库
     *
     * @param doneEvent
     */
    @Override
    public void visitDone(VisitStepListenerDoneEvent doneEvent) {

    }

    /**
     * 拜访提交(包括工作台的业务事件)，持久化到数据库（用户有可能会反复编辑，生成多个事件）
     *
     * @param committedEvent
     */
    @Override
    public void committed(VisitStepListenerCommittedEvent committedEvent) {
        List<? extends VisitStepListenerCommittedData> entities = committedEvent.getEntities();
        //业务动态
        SfaBusinessDetailSaveMQSend.saveBusinessDetail(entities);
    }
}
