package com.biz.crm.customer.controller;

import com.biz.crm.customer.service.SfaCustomerBusinessDetailService;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.nebular.sfa.customer.req.SfaCustomerBusinessDetailReqVo;
import com.biz.crm.util.JsonPropertyUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.List;

/**
 * 业务动态保存
 * @author yangshan
 * @date 2021/4/11 22:56
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = "${rocketmq.topic}" + "${rocketmq.environment-variable}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag定义在 RocketMQConstant.CRM_MQ_TAG 内统一维护
        */
        selectorExpression = RocketMQConstant.CRM_MQ_TAG.CUSTOMER_BUSINESS_DETAIL_TAG,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup定义在 RocketMQConstant.CONSUMER_GROUP 内统一维护
        */
        consumerGroup = RocketMQConstant.CONSUMER_GROUP.CUSTOMER_BUSINESS_DETAIL + "${rocketmq.environment-variable}")
public class SfaBusinessDetailMQConsumer extends AbstractRocketMQConsumer {
    @Resource
    private SfaCustomerBusinessDetailService sfaCustomerBusinessDetailService;

    /**
     * 消费消息
     *
     * @param message
     * @return
     */
    @Override
    protected Object handleMessage(RocketMQMessageBody message) throws InterruptedException {
        String msg = message.getMsgBody();
        if(StringUtils.isEmpty(msg)){
            return "消息为空!";
        }
        List<SfaCustomerBusinessDetailReqVo> reqVo = JsonPropertyUtil.toArray(msg,SfaCustomerBusinessDetailReqVo.class);
        if(StringUtils.isEmpty(reqVo)){
            return "记录为空!";
        }
        this.sfaCustomerBusinessDetailService.saveList(reqVo);
        return "操作成功";
    }
}
