package com.biz.crm.customer.controller;


import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.customer.service.SfaCustomerBusinessDetailService;
import com.biz.crm.nebular.sfa.customer.req.SfaCustomerBusinessDetailReqVo;
import com.biz.crm.nebular.sfa.customer.resp.SfaCustomerBusinessDetailRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 客户业务动态
 *
 * @author yangshan
 * @date 2021-3-4 10:21:32
 */
@Slf4j
@RestController
@RequestMapping("/sfaCustomerBusinessDetailController")
@Api(tags = "客户业务动态")
public class SfaCustomerBusinessDetailController {
    @Autowired
    private SfaCustomerBusinessDetailService sfaCustomerBusinessDetailService;

    @ApiOperation(value = "分页查询")
    @PostMapping("/page")
    @CrmDictMethod
    @CrmLog
    public Result<PageResult<SfaCustomerBusinessDetailRespVo>> page(@RequestBody SfaCustomerBusinessDetailReqVo reqVo){
        PageResult<SfaCustomerBusinessDetailRespVo> result = sfaCustomerBusinessDetailService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaCustomerBusinessDetailReqVo reqVo) {
        sfaCustomerBusinessDetailService.save(reqVo);
        return Result.ok();
    }
}
