package com.biz.crm.customer.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.customer.service.SfaCustomerInventoryRecordsService;
import com.biz.crm.nebular.sfa.customer.resp.SfaCustomerInventoryRecordsRespVo;
import com.biz.crm.nebular.sfa.visitstepdetail.resp.SfaVisitStepStockInventoryRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author yangshan
 * @date 2021/3/4 21:07
 */
@Slf4j
@RestController
@RequestMapping("/sfaCustomerInventoryRecordsController")
@Api(tags = "客户库存盘点记录")
public class SfaCustomerInventoryRecordsController {

    @Autowired
    private SfaCustomerInventoryRecordsService sfaCustomerInventoryRecordsService;


    @ApiOperation(value = "查询", httpMethod = "GET")
    @GetMapping("/findInventoryRecords")
    @CrmLog
    @Deprecated
    public Result<SfaCustomerInventoryRecordsRespVo> findInventoryRecords(@RequestParam String clientCode){
        SfaCustomerInventoryRecordsRespVo result = sfaCustomerInventoryRecordsService.findInventoryRecords(clientCode);
        return Result.ok(result);
    }

    @ApiOperation(value = "查询", httpMethod = "GET")
    @GetMapping("/findInventoryRecordsEs")
    @CrmLog
    public Result<SfaCustomerInventoryRecordsRespVo> findInventoryRecordsEs(@RequestParam String clientCode){
        SfaCustomerInventoryRecordsRespVo result = sfaCustomerInventoryRecordsService.findInventoryRecordsEs(clientCode);
        return Result.ok(result);
    }
}
