package com.biz.crm.customer.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.customer.service.SfaCustomerVisitTotalService;
import com.biz.crm.nebular.sfa.customer.resp.SfaCustomerVisitTotalRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 客户月度拜访统计
 * @author yangshan
 * @date 2021/3/4 22:27
 */
@Slf4j
@RestController
@RequestMapping("/sfaCustomerVisitTotalController")
@Api(tags = "客户月度拜访统计")
public class SfaCustomerVisitTotalController {

    @Autowired
    private SfaCustomerVisitTotalService sfaCustomerVisitTotalService;

    @ApiOperation(value = "客户月度拜访统计", httpMethod = "GET")
    @GetMapping("/findCustomerVisitTotal")
    @CrmLog
    public Result<List<SfaCustomerVisitTotalRespVo>> findCustomerVisitTotal(@RequestParam String clientCode){
        List<SfaCustomerVisitTotalRespVo> list = sfaCustomerVisitTotalService.findCustomerVisitTotal(clientCode);
        return Result.ok(list);
    }
}
