package com.biz.crm.customer.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.mapper.SfaCustomerBusinessDetailMapper;
import com.biz.crm.customer.model.SfaCustomerBusinessDetailEntity;
import com.biz.crm.customer.service.SfaCustomerBusinessDetailService;
import com.biz.crm.nebular.sfa.customer.req.SfaCustomerBusinessDetailReqVo;
import com.biz.crm.nebular.sfa.customer.resp.SfaCustomerBusinessDetailRespVo;
import com.biz.crm.util.*;
import com.biz.crm.visitstep.model.*;
import jodd.util.ObjectUtil;
import lombok.extern.slf4j.Slf4j;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 客户信息业务动态接口实现
 *
 * @author yangshan
 * @date 2021-3-4 10:00:48
 */
@Slf4j
@Service
public class SfaCustomerBusinessDetailServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaCustomerBusinessDetailMapper, SfaCustomerBusinessDetailEntity> implements SfaCustomerBusinessDetailService {

    @Resource
    private ElasticsearchTemplate elasticsearchTemplate;
    @Resource
    private SfaCustomerBusinessDetailMapper sfaCustomerBusinessDetailMapper;

    @Override
    public PageResult<SfaCustomerBusinessDetailRespVo> findList(SfaCustomerBusinessDetailReqVo reqVo) {
//
//        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
//        if (StringUtils.isNotEmpty(reqVo.getClientCode())){
//            boolQueryBuilder.must(QueryBuilders.termQuery("clientCode.keyword",reqVo.getClientCode()));
//        }
//        SearchQuery searchQuery = new NativeSearchQueryBuilder()
//                //多个索引查询
//                .withIndices(SfaVisitStepActivityDisplayExecutionEsData.TABLE_NAME,
//                        SfaVisitStepActivityCostExecutionEsData.TABLE_NAME,
//                        SfaVisitStepColletEsData.TABLE_NAME,
//                        SfaVisitStepOrderEsData.TABLE_NAME,
//                        SfaVisitStepStoreCheckEsData.TABLE_NAME)
//                //查询条件
//                .withQuery(boolQueryBuilder)
//                .withSort(SortBuilders.fieldSort("createDate").unmappedType("keyword").order(SortOrder.DESC))
//                .withSort(SortBuilders.fieldSort("createDateSecond").unmappedType("keyword").order(SortOrder.DESC))
//                //分页参数
//                .withPageable(PageRequest.of(reqVo.getPageNum(),reqVo.getPageSize()))
//                .build();
//
//
//        List<SfaCustomerBusinessDetailRespVo> result = new ArrayList<>();
//        elasticsearchTemplate.query(searchQuery, response -> {
//            SearchHit[] searchHits = response.getHits().getHits();
//            if(null == searchHits){
//                return result;
//            }
//
//            Arrays.stream(searchHits).forEach(h -> {
//                Map<String, Object> source = h.getSourceAsMap();
//                if(null != source){
//                    SfaCustomerBusinessDetailRespVo user = JSON.parseObject(JSON.toJSONString(source),SfaCustomerBusinessDetailRespVo.class);
//                    if (!ObjectUtils.isEmpty(source.get("id"))){
//                        user.setBusinessCode(source.get("id").toString());
//                    }
//                    if (!ObjectUtils.isEmpty(source.get("sfaVisitStepFrom"))){
//                        HashMap sfaVisitStepFrom = (HashMap) source.get("sfaVisitStepFrom");
//                        if (!ObjectUtils.isEmpty(sfaVisitStepFrom.get("fromName"))){
//                            String fromName = (String) sfaVisitStepFrom.get("fromName");
//                            String[] split = fromName.split("-");
//                            user.setBusinessType(split[0]);
//                        }
//                    }
//                    result.add(user);
//                }
//            });
//            return result;
//        });



        Page<SfaCustomerBusinessDetailRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaCustomerBusinessDetailRespVo> list = sfaCustomerBusinessDetailMapper.findList(page, reqVo);

        return PageResult.<SfaCustomerBusinessDetailRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public void save(SfaCustomerBusinessDetailReqVo reqVo) {
        this.deCheck(reqVo);
        SfaCustomerBusinessDetailEntity entity = CrmBeanUtil.copy(reqVo, SfaCustomerBusinessDetailEntity.class);
        this.save(entity);
    }

    @Override
    public void saveList(List<SfaCustomerBusinessDetailReqVo> reqVo) {
        log.warn("当前登录人信息:{}", UserUtils.getUser());
        if (CollectionUtil.listNotEmpty(reqVo)){
            reqVo.forEach(this::deCheck);
            List<SfaCustomerBusinessDetailEntity> entity = CrmBeanUtil.copyList(reqVo, SfaCustomerBusinessDetailEntity.class);
            entity.forEach(o -> {
                //置空id
                o.setId(null);
                this.lambdaUpdate().eq(SfaCustomerBusinessDetailEntity::getBusinessCode, o.getBusinessCode())
                        .eq(SfaCustomerBusinessDetailEntity::getStepCode, o.getStepCode())
                        .remove();
            });
            this.saveBatch(entity);
        }
    }

    public void deCheck(SfaCustomerBusinessDetailReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getClientCode(),"客户编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getBusinessType(),"业务类型不能为空");
        AssertUtils.isNotEmpty(reqVo.getBusinessCode(),"业务编码不能为空");
        AssertUtils.isNotEmpty(reqVo.getStepCode(),"拜访步骤编码不能为空");
//        AssertUtils.isNotEmpty(reqVo.getVisitPlanInfoId(),"拜访计划明细id不能为空");
        AssertUtils.isNotEmpty(reqVo.getClientName(),"客户名称不能为空");
        AssertUtils.isNotEmpty(reqVo.getClientType(),"客户类型不能为空");
        AssertUtils.isNotEmpty(reqVo.getClientSubclass(),"客户细类不能为空");
    }
}
