package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.customer.mapper.SfaCustomerInventoryRecordsMapper;
import com.biz.crm.customer.service.SfaCustomerInventoryRecordsService;
import com.biz.crm.moblie.controller.visit.req.step.StockInventoryStepExecuteData;
import com.biz.crm.nebular.sfa.customer.resp.SfaCustomerInventoryRecordsRespVo;
import com.biz.crm.nebular.sfa.visitstepdetail.resp.SfaVisitStepStockInventoryRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitstep.repositories.SfaVisitStepStockInventoryEsDataRepositories;
import com.biz.crm.visitstep.req.GetStockInventoryPageReq;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEntity;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEsData;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;

/**
 * 查询库存记录
 * @author yangshan
 * @date 2021/3/4 21:22
 */
@Slf4j
@Service
public class SfaCustomerInventoryRecordsServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaCustomerInventoryRecordsMapper, SfaVisitStepStockInventoryEntity> implements SfaCustomerInventoryRecordsService {

    @Autowired
    private SfaCustomerInventoryRecordsMapper sfacustomerInventoryRecordsMapper;
    @Resource
    private SfaVisitStepStockInventoryEsDataRepositories sfaVisitStepStockInventoryEsDataRepositories;
    /**
     * 查询库存记录
     * @param clientCode
     * @return
     */
    @Override
    public SfaCustomerInventoryRecordsRespVo findInventoryRecords(String clientCode) {
        //取最新两条记录
        Page<SfaCustomerInventoryRecordsRespVo> page = new Page<>(1, 2);
        List<SfaCustomerInventoryRecordsRespVo> records = sfacustomerInventoryRecordsMapper.findInventoryRecords(page, clientCode);
        if (ObjectUtils.isEmpty(records)){
            return new SfaCustomerInventoryRecordsRespVo();
        }
        //计算库存差
        if (records.size() == 1){
            return records.get(0).setQuantityDifference(records.get(0).getQuantity());
        }
        SfaCustomerInventoryRecordsRespVo respVo = records.get(0);
        BigDecimal thisQuantity = new BigDecimal(records.get(0).getQuantity());
        BigDecimal lastQuantity = new BigDecimal(records.get(1).getQuantity());
        respVo.setQuantityDifference(thisQuantity.subtract(lastQuantity).toString());
        return respVo;
    }

    @Override
    public SfaCustomerInventoryRecordsRespVo findInventoryRecordsEs(String clientCode) {
        GetStockInventoryPageReq req = new GetStockInventoryPageReq();
        req.setClientCode(clientCode);
        req.setStepCode("sfa_step_code_stock");
        org.springframework.data.domain.Page<SfaVisitStepStockInventoryEsData> list = this.sfaVisitStepStockInventoryEsDataRepositories.search(req.buildQuery());
        if (CollectionUtil.listEmpty(list.getContent())){
            return new SfaCustomerInventoryRecordsRespVo();
        }

        SfaCustomerInventoryRecordsRespVo respVo = CrmBeanUtil.copy(list.getContent().get(0), SfaCustomerInventoryRecordsRespVo.class);
        List<StockInventoryStepExecuteData.StockDetailReqVo> visitStepStockList = list.getContent().get(0).getVisitStepStockList();
        if (CollectionUtil.listEmpty(visitStepStockList)){
            return new SfaCustomerInventoryRecordsRespVo();
        }
        //库存数量
        Integer stockNum = visitStepStockList.stream().mapToInt(StockInventoryStepExecuteData.StockDetailReqVo::getQuantity).sum();
        respVo.setQuantity(stockNum.toString());
        //系列数
        Long seriesNum = visitStepStockList.stream().map(StockInventoryStepExecuteData.StockDetailReqVo::getProductLevelCode).count();
        respVo.setSeriesNum(seriesNum.toString());
        //种类数量
        Long typeNum = visitStepStockList.stream().map(StockInventoryStepExecuteData.StockDetailReqVo::getProductCode).count();
        respVo.setTypeNum(typeNum.toString());
        //库存差
        Integer lastStockNum = stockNum;
        respVo.setQuantityDifference((BigDecimal.valueOf(stockNum).subtract(BigDecimal.valueOf(lastStockNum))).toString());
        if (list.getContent().size() == 1){
            return respVo;
        }
        lastStockNum = list.getContent().get(1).getVisitStepStockList().stream().mapToInt(StockInventoryStepExecuteData.StockDetailReqVo::getQuantity).sum();
        respVo.setQuantityDifference((BigDecimal.valueOf(stockNum).subtract(BigDecimal.valueOf(lastStockNum))).toString());
        return respVo;
    }
}
