package com.biz.crm.enums;

/**
 * @Project crm-core
 * @PackageName com.biz.crm.enums
 * @Author lifei
 * @Date 2020/11/11
 * @Description
 */
public enum SfaNoticeEnum {

    notice_current_org("currentOrg","当前组织"),
    notice_current_down_org("currentDownOrg","当前组织及以下"),

    notice_type_policy("policy","政策"),
    notice_type_advise("advise","通知"),
    notice_type_file("file","文件"),

    ;

    private String code;
    private String desc;

    SfaNoticeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static SfaNoticeEnum getSfaNotice(String code){
        for (SfaNoticeEnum role:SfaNoticeEnum.values()) {
            if (code.equals(role.getCode())){
                return role;
            }
        }
        return null;
    }
}
