package com.biz.crm.enums;

import com.biz.crm.eunm.sfa.SfaVisitEnum;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author hej
 * @Created Date 2020-11-18
 **/
public enum SfaTaskStatusEnum {

    // 0待执行 1已完成 2已回绝 3已过期
    WAIT_EXECUTE("0","待执行"),
    EXECUTE_LODING("1","已完成"),
    ALREADY_FINISH("2","已回绝"),
    PAST_DUE("3","已过期");

    private String code;
    private String desc;

    private SfaTaskStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    private String code(){
        return this.code;
    }

    private String desc(){
        return this.desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getValue(String code) {
        SfaTaskStatusEnum[] sfaTaskStatusEnums = values();
        for (SfaTaskStatusEnum sfaTaskStatusEnum : sfaTaskStatusEnums) {
            if (sfaTaskStatusEnum.code().equals(code)) {
                return sfaTaskStatusEnum.desc();
            }
        }
        return null;
    }

    public static String getType(String desc) {
        SfaTaskStatusEnum[] sfaTaskStatusEnums = values();
        for (SfaTaskStatusEnum sfaTaskStatusEnum : sfaTaskStatusEnums) {
            if (sfaTaskStatusEnum.desc().equals(desc)) {
                return sfaTaskStatusEnum.code();
            }
        }
        return null;
    }

    public static Map<String,String> GETMAP = new HashMap<>();
    static {
        for (SfaVisitEnum.visitStatus type : SfaVisitEnum.visitStatus.values()) {
            GETMAP.put(type.getVal(), type.getDesc());
        }
    }


}
