package com.biz.crm.freesignconfig.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.freesignconfig.service.ISfaFreesignSignTypeService;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignSignTypeRespVo;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignSignTypeReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 签到组--打卡类型 
 *
 * @author liuhongming
 * @date 2020-09-17 14:40:27
 */
@Slf4j
@RestController
@RequestMapping("/sfafreesignsigntype")
@Api(tags = "签到组--打卡类型(废弃) ")
public class SfaFreesignSignTypeController {
    @Autowired
    private ISfaFreesignSignTypeService sfaFreesignSignTypeService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaFreesignSignTypeRespVo>> list(@RequestBody SfaFreesignSignTypeReqVo sfaFreesignSignTypeReqVo) {
        PageResult<SfaFreesignSignTypeRespVo> result=sfaFreesignSignTypeService.findList(sfaFreesignSignTypeReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaFreesignSignTypeRespVo> query(@RequestBody SfaFreesignSignTypeReqVo sfaFreesignSignTypeReqVo) {
        SfaFreesignSignTypeRespVo respVo=sfaFreesignSignTypeService.query(sfaFreesignSignTypeReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaFreesignSignTypeReqVo sfaFreesignSignTypeReqVo) {
        sfaFreesignSignTypeService.save(sfaFreesignSignTypeReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaFreesignSignTypeReqVo sfaFreesignSignTypeReqVo) {
        sfaFreesignSignTypeService.update(sfaFreesignSignTypeReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody SfaFreesignSignTypeReqVo sfaFreesignSignTypeReqVo) {
        sfaFreesignSignTypeService.deleteBatch(sfaFreesignSignTypeReqVo);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody SfaFreesignSignTypeReqVo sfaFreesignSignTypeReqVo) {
        sfaFreesignSignTypeService.enableBatch(sfaFreesignSignTypeReqVo);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody  SfaFreesignSignTypeReqVo sfaFreesignSignTypeReqVo) {
        sfaFreesignSignTypeService.disableBatch(sfaFreesignSignTypeReqVo);
        return Result.ok("禁用成功");
    }
}
