package com.biz.crm.freesignconfig.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 签到组-打卡人员 实体类
 *
 * @author liuhongming
 * @date 2020-09-17 14:40:27
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_freesign_personnel")
@CrmTable(name = "sfa_freesign_personnel", tableNote = "拜访步骤 -控件目录信息明细 ")
public class SfaFreesignPersonnelEntity extends CrmExtTenEntity<SfaFreesignPersonnelEntity> {

    /**
     * 编码 编码
     */
    @CrmColumn(name = "personnel_code", length = 32, note = "编码")
    private String personnelCode;

    /**
     * 名称 名称
     */
    @CrmColumn(name = "personnel_name", length = 100, note = "名称")
    private String personnelName;

    /**
     * 组织范围 组织范围(10:当前组织;20:当前组织及下级组织)
     */
    @CrmColumn(name = "org_range", length = 32, note = "组织范围 组织范围(10:当前组织;20:当前组织及下级组织)")
    private String orgRange;

    /**
     * 类型 类型(1:组织类型;2:组织;3:人员)
     */
    @CrmColumn(name = "personnel_type", length = 32, note = "类型 类型(1:组织类型;2:组织;3:人员)")
    private String personnelType;

    /**
     * 范围类型 范围类型(1:包含;2:非包含;)
     */
    @CrmColumn(name = "range_type", length = 32, note = "范围类型 范围类型(1:包含;2:非包含;)")
    private String rangeType;

    /**
     * 签到组编码 签到组编码
     */
    @CrmColumn(name = "freesign_code", length = 32, note = "签到组编码")
    private String freesignCode;

}
