package com.biz.crm.freesignconfig.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 签到组与打卡类型 关系表
 *
 * @author liuhongming
 * @date 2020-09-17 14:40:27
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_freesign_sign")
@CrmTable(name = "sfa_freesign_sign", tableNote = "签到组与打卡类型")
public class SfaFreesignSignEntity extends CrmExtTenEntity<SfaFreesignSignEntity> {

    /** 签到组编码 */
    @CrmColumn(name = "freesign_code", length = 32, note = "签到组编码")
    private String freesignCode;
    /** 打卡类型id */
    @CrmColumn(name = "sign_type_id", length = 32, note = "打卡类型id")
    private String signTypeId ;
    /**打卡类型编码 打卡类型编码*/
    @CrmColumn(name = "sign_type_code", length = 32, note = "打卡类型编码")
    private String signTypeCode;
    /** 打卡类型名称 */
    @CrmColumn(name = "sign_type_name", length = 200, note = "打卡类型名称")
    private String signTypeName ;



}
