package com.biz.crm.freesignconfig.service;

import com.biz.crm.freesignconfig.model.SfaFreesignConfigEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignConfigRespVo;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignConfigReqVo;
import com.biz.crm.util.Result;

import java.util.Map;

/**
 * 签到组 接口
 *
 * @author liuhongming
 * @date 2020-09-17 14:40:27
 */
public interface ISfaFreesignConfigService extends IService<SfaFreesignConfigEntity> {

    /**
     * 列表
     * @param sfaFreesignConfigReqVo
     * @return PageResult<SfaFreesignConfigRespVo>
     */
    PageResult<SfaFreesignConfigRespVo> findList(SfaFreesignConfigReqVo sfaFreesignConfigReqVo);

    /**
     * 查询
     * @param sfaFreesignConfigReqVo
     * @return SfaFreesignConfigRespVo
     */
    SfaFreesignConfigRespVo query(SfaFreesignConfigReqVo sfaFreesignConfigReqVo);

    /**
     * 新增
     * @param sfaFreesignConfigReqVo
     * @return
     */
    void save(SfaFreesignConfigReqVo sfaFreesignConfigReqVo);

    /**
     * 更新
     * @param sfaFreesignConfigReqVo
     * @return
     */
    void update(SfaFreesignConfigReqVo sfaFreesignConfigReqVo);

    /**
     * 删除
     * @param sfaFreesignConfigReqVo
     * @return
     */
    void deleteBatch(SfaFreesignConfigReqVo sfaFreesignConfigReqVo);

    /**
     * 启用
     * @param sfaFreesignConfigReqVo
     * @return
     */
    void enableBatch(SfaFreesignConfigReqVo sfaFreesignConfigReqVo);

    /**
     * 禁用
     * @param sfaFreesignConfigReqVo
     * @return
     */
    void disableBatch(SfaFreesignConfigReqVo sfaFreesignConfigReqVo);

    /***************************************************微信端接口查询******************************************************/

    /**
     * 自由签到查询当前登录人  所有签到组
     * @return
     */
    Result<SfaFreesignConfigRespVo> findFreesignConfigList();




}

