package com.biz.crm.freesignconfig.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.freesignconfig.mapper.SfaFreesignSignMapper;
import com.biz.crm.freesignconfig.mapper.SfaFreesignSignTypeMapper;
import com.biz.crm.freesignconfig.model.SfaFreesignSignEntity;
import com.biz.crm.freesignconfig.model.SfaFreesignSignTypeEntity;
import com.biz.crm.freesignconfig.service.ISfaFreesignSignService;
import com.biz.crm.freesignconfig.service.ISfaFreesignSignTypeService;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignSignReqVo;
import com.biz.crm.nebular.sfa.freesignconfig.req.SfaFreesignSignTypeReqVo;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignSignRespVo;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignSignTypeRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 签到组与打卡类型 关系表 接口实现
 *
 * @author liuhongming
 * @date 2020-09-17 14:40:27
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaFreesignSignServiceExpandImpl")
public class SfaFreesignSignServiceImpl extends ServiceImpl<SfaFreesignSignMapper, SfaFreesignSignEntity> implements ISfaFreesignSignService {

    @Resource
    private SfaFreesignSignMapper sfaFreesignSignMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    @CrmLog
    public PageResult<SfaFreesignSignRespVo> findList(SfaFreesignSignReqVo reqVo){
        Page<SfaFreesignSignRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaFreesignSignRespVo> list = sfaFreesignSignMapper.findList(page, reqVo);
        return PageResult.<SfaFreesignSignRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }


}
