package com.biz.crm.helpdefense.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.helpdefense.service.ISfaVisitHelpDefenseDetailService;
import com.biz.crm.nebular.sfa.helpdefense.req.SfaVisitHelpDefenseDetailReqVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaVisitHelpDefenseDetailRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 拜访-协防执行步骤详情;
 *
 * @author lf
 * @date 2021-01-11 15:42:32
 */
@Slf4j
@RestController
@RequestMapping("/sfavisithelpdefensedetail")
@Api(tags = "拜访-协防执行步骤详情;")
public class SfaVisitHelpDefenseDetailController {
    @Autowired
    private ISfaVisitHelpDefenseDetailService sfaVisitHelpDefenseDetailService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<SfaVisitHelpDefenseDetailRespVo>> list(@RequestBody SfaVisitHelpDefenseDetailReqVo sfaVisitHelpDefenseDetailReqVo) {
        PageResult<SfaVisitHelpDefenseDetailRespVo> result=sfaVisitHelpDefenseDetailService.findList(sfaVisitHelpDefenseDetailReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<SfaVisitHelpDefenseDetailRespVo> query(@RequestBody SfaVisitHelpDefenseDetailReqVo sfaVisitHelpDefenseDetailReqVo) {
        SfaVisitHelpDefenseDetailRespVo respVo=sfaVisitHelpDefenseDetailService.query(sfaVisitHelpDefenseDetailReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody SfaVisitHelpDefenseDetailReqVo sfaVisitHelpDefenseDetailReqVo) {
        sfaVisitHelpDefenseDetailService.save(sfaVisitHelpDefenseDetailReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody SfaVisitHelpDefenseDetailReqVo sfaVisitHelpDefenseDetailReqVo) {
        sfaVisitHelpDefenseDetailService.update(sfaVisitHelpDefenseDetailReqVo);
        return Result.ok("修改成功");
    }
}
