package com.biz.crm.helpdefense.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.helpdefense.model.SfaHelpDefenseEntity;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.sfa.helpdefense.req.SfaHelpDefenseReqVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaHelpDefenseRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 协防执行;
 * 
 * @author lf
 * @date 2021-01-05 15:45:45
 */
public interface SfaHelpDefenseMapper extends BaseMapper<SfaHelpDefenseEntity> {
    /**
     * 列表
     * @param page
     * @param sfaHelpDefenseReqVo
     * @return
     */
    @SqlPrivilege(orgCode = "shd.help_org_code",posCode = "shd.help_pos_code")
    List<SfaHelpDefenseRespVo> findList(Page<SfaHelpDefenseRespVo> page, @Param("vo") SfaHelpDefenseReqVo sfaHelpDefenseReqVo);
    /**
     * 通过协防人员职位，被协防人员职位，协防时间查询
     * @param sfaHelpDefenseReqVo
     * @return
     */
    Integer selectSfaHelpDefenseCountByCondition(@Param("vo") SfaHelpDefenseReqVo sfaHelpDefenseReqVo);

}
