package com.biz.crm.helpdefense.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 协防计划
 *
 * @author lf
 * @date 2021-01-05 15:45:45
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_help_defense")
@CrmTable(name = "sfa_help_defense", tableNote = "协防计划")
public class SfaHelpDefenseEntity extends CrmExtTenEntity<SfaHelpDefenseEntity> {

    /**
     * 协防人员账号
     */
    @CrmColumn(name = "help_user_name", length = 50, note = "协防人员账号")
    private String helpUserName;

    /**
     * 协防人员姓名
     */
    @CrmColumn(name = "help_real_name", length = 50, note = "协防人员姓名")
    private String helpRealName;

    /**
     * 协防组织编码
     */
    @CrmColumn(name = "help_org_code", length = 50, note = "协防组织编码")
    private String helpOrgCode;

    /**
     * 协防组织名称
     */
    @CrmColumn(name = "help_org_name", length = 50, note = "协防组织名称")
    private String helpOrgName;

    /**
     * 协防职位编码
     */
    @CrmColumn(name = "help_pos_code", length = 50, note = "协防职位编码")
    private String helpPosCode;

    /**
     * 协防职位名称
     */
    @CrmColumn(name = "help_pos_name", length = 50, note = "协防职位名称")
    private String helpPosName;

    /**
     * 协防日期
     */
    @CrmColumn(name = "help_defense_date", length = 32, note = "协防日期")
    private String helpDefenseDate;

    /**
     * 被协访人员姓名
     */
    @CrmColumn(name = "cover_help_real_name", length = 300, note = "被协访人员姓名")
    private String coverHelpRealName;


}
