package com.biz.crm.helpdefense.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 拜访-协防执行步骤详情;实体类
 *
 * @author lf
 * @date 2021-01-11 15:42:32
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("sfa_visit_help_defense_detail")
@CrmTable(name = "sfa_visit_help_defense_detail", tableNote = "拜访-协防执行步骤详情;")
public class SfaVisitHelpDefenseDetailEntity extends CrmExtTenEntity<SfaVisitHelpDefenseDetailEntity> {

    /**
     * 拜访-协防执行id
     */
    @CrmColumn(name = "visit_help_defense_id", length = 32, note = "拜访-协防执行id")
    private String visitHelpDefenseId;

    /**
     * 步骤编码
     */
    @CrmColumn(name = "directory_code", length = 32, note = "步骤编码")
    private String directoryCode;

    /**
     * 步骤名称
     */
    @CrmColumn(name = "directory_name", length = 100, note = "步骤名称")
    private String directoryName;

    /**
     * 是否合格(0-否,1-是)
     */
    @CrmColumn(name = "is_qualified", length = 5, note = "是否合格(0-否,1-是)")
    private String isQualified;

}
