package com.biz.crm.helpdefense.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.helpdefense.model.SfaHelpDefenseEntity;
import com.biz.crm.nebular.sfa.helpdefense.req.SfaHelpDefenseReqVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaHelpDefenseRespVo;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;

import java.util.List;

/**
 * 协防执行;接口
 *
 * @author lf
 * @date 2021-01-05 15:45:45
 */
public interface ISfaHelpDefenseService extends IService<SfaHelpDefenseEntity> {

    /**
     * 列表
     * @param sfaHelpDefenseReqVo
     * @return PageResult<SfaHelpDefenseRespVo>
     */
    PageResult<SfaHelpDefenseRespVo> findList(SfaHelpDefenseReqVo sfaHelpDefenseReqVo);

    /**
     * 查询协防计划详情信息
     * @param reqVo
     * @return
     */
    SfaHelpDefenseRespVo findSfaHelpDefenseDetail(SfaHelpDefenseReqVo reqVo);

    /**
     * 通过主键id查询详情
     * @param id
     * @return
     */
    SfaHelpDefenseRespVo queryDetailById(String id);

    /**
     * 新增协访计划
     * @param sfaHelpDefenseReqVo
     * @return
     */
    void save(SfaHelpDefenseReqVo sfaHelpDefenseReqVo);

    /**
     * 查询被协防的拜访网点信息
     * @param reqVo
     * @return
     */
    List<SfaVisitPlanInfoRespVo> findSfaVisitPlanInfoList(SfaVisitPlanInfoReqVo reqVo);

    /**
     * 查询所有被协防的拜访网点信息
     * @param reqVo
     * @return
     */
    List<SfaVisitPlanInfoRespVo> findAllSfaVisitPlanInfoList(SfaVisitPlanInfoReqVo reqVo);

    /**
     * 更新
     * @param sfaHelpDefenseReqVo
     * @return
     */
    void update(SfaHelpDefenseReqVo sfaHelpDefenseReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param sfaHelpDefenseReqVo
     * @return
     */
    void enableBatch(SfaHelpDefenseReqVo sfaHelpDefenseReqVo);

    /**
     * 禁用
     * @param sfaHelpDefenseReqVo
     * @return
     */
    void disableBatch(SfaHelpDefenseReqVo sfaHelpDefenseReqVo);

    /**
     * 通过id批量查询终端名称
     * @param ids
     * @return
     */
    List<SfaHelpDefenseRespVo> queryListById(List<String> ids);

    /**
     * 协防计划删除校验
     * @param coverHelpPosCode
     * @param id
     */
    void checkIsDelete(String id, String coverHelpPosCode);
}

