package com.biz.crm.helpdefense.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.helpdefense.mapper.SfaHelpDefenseDetailMapper;
import com.biz.crm.helpdefense.model.SfaHelpDefenseDetailEntity;
import com.biz.crm.helpdefense.service.ISfaHelpDefenseDetailService;
import com.biz.crm.nebular.sfa.helpdefense.req.SfaHelpDefenseDetailReqVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaHelpDefenseDetailRespVo;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 协防执行明细;接口实现
 *
 * @author lf
 * @date 2021-01-05 15:45:45
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaHelpDefenseDetailServiceExpandImpl")
public class SfaHelpDefenseDetailServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaHelpDefenseDetailMapper, SfaHelpDefenseDetailEntity> implements ISfaHelpDefenseDetailService {

    @Resource
    private SfaHelpDefenseDetailMapper sfaHelpDefenseDetailMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaHelpDefenseDetailRespVo> findList(SfaHelpDefenseDetailReqVo reqVo){
        Page<SfaHelpDefenseDetailRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaHelpDefenseDetailRespVo> list = sfaHelpDefenseDetailMapper.findList(page, reqVo);
        return PageResult.<SfaHelpDefenseDetailRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaHelpDefenseDetailRespVo
     */
    @Override
    public SfaHelpDefenseDetailRespVo query(SfaHelpDefenseDetailReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmAPIDiscard
    @Deprecated
    public void save(SfaHelpDefenseDetailReqVo reqVo){
//        11
        SfaHelpDefenseDetailEntity entity = CrmBeanUtil.copy(reqVo,SfaHelpDefenseDetailEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaHelpDefenseDetailReqVo reqVo){
        SfaHelpDefenseDetailEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(SfaHelpDefenseDetailReqVo reqVo){
        List<SfaHelpDefenseDetailEntity> sfaHelpDefenseDetailEntities = sfaHelpDefenseDetailMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaHelpDefenseDetailEntities)){
            sfaHelpDefenseDetailEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaHelpDefenseDetailEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(SfaHelpDefenseDetailReqVo reqVo){
        //设置状态为启用
        List<SfaHelpDefenseDetailEntity> sfaHelpDefenseDetailEntities = sfaHelpDefenseDetailMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaHelpDefenseDetailEntities)){
            sfaHelpDefenseDetailEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaHelpDefenseDetailEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(SfaHelpDefenseDetailReqVo reqVo){
        //设置状态为禁用
        List<SfaHelpDefenseDetailEntity> sfaHelpDefenseDetailEntities = sfaHelpDefenseDetailMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(sfaHelpDefenseDetailEntities)){
                sfaHelpDefenseDetailEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(sfaHelpDefenseDetailEntities);
    }
}
