package com.biz.crm.helpdefense.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.helpdefense.mapper.SfaVisitHelpDefenseDetailMapper;
import com.biz.crm.helpdefense.model.SfaVisitHelpDefenseDetailEntity;
import com.biz.crm.helpdefense.service.ISfaVisitHelpDefenseDetailService;
import com.biz.crm.nebular.sfa.helpdefense.req.SfaVisitHelpDefenseDetailReqVo;
import com.biz.crm.nebular.sfa.helpdefense.resp.SfaVisitHelpDefenseDetailRespVo;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 拜访-协防执行步骤详情;接口实现
 *
 * @author lf
 * @date 2021-01-11 15:42:32
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="SfaVisitHelpDefenseDetailServiceExpandImpl")
public class SfaVisitHelpDefenseDetailServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<SfaVisitHelpDefenseDetailMapper, SfaVisitHelpDefenseDetailEntity> implements ISfaVisitHelpDefenseDetailService {

    @Resource
    private SfaVisitHelpDefenseDetailMapper sfaVisitHelpDefenseDetailMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<SfaVisitHelpDefenseDetailRespVo> findList(SfaVisitHelpDefenseDetailReqVo reqVo){
        Page<SfaVisitHelpDefenseDetailRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaVisitHelpDefenseDetailRespVo> list = sfaVisitHelpDefenseDetailMapper.findList(page, reqVo);
        return PageResult.<SfaVisitHelpDefenseDetailRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return sfaVisitHelpDefenseDetailRespVo
     */
    @Override
    public SfaVisitHelpDefenseDetailRespVo query(SfaVisitHelpDefenseDetailReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SfaVisitHelpDefenseDetailReqVo reqVo){
        SfaVisitHelpDefenseDetailEntity entity = CrmBeanUtil.copy(reqVo,SfaVisitHelpDefenseDetailEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(SfaVisitHelpDefenseDetailReqVo reqVo){
        SfaVisitHelpDefenseDetailEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }
}
