package com.biz.crm.integral.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.cache.util.IntegralUserUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.integral.service.SfaIntegralDetailService;
import com.biz.crm.integral.service.component.SfaIntegralMonthJobExecutor;
import com.biz.crm.nebular.sfa.integral.req.SfaIntegralDetailReqVo;
import com.biz.crm.nebular.sfa.integral.req.SfaIntegralDetailUserReqVo;
import com.biz.crm.nebular.sfa.integral.req.SfaIntegralRankAppReqVo;
import com.biz.crm.nebular.sfa.integral.req.SfaIntegralRankReqVo;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralDetailRespVo;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralRankRespVo;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralUserRankRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * 积分报表接口
 * @author YuanZiJian
 * @date 2021/1/12 15:03
 * @version: V1.0
 */
@Slf4j
@RestController
@RequestMapping("/sfaIntegralDetail")
@Api(tags = "积分明细")
public class SfaIntegralDetailController {

    @Resource
    private SfaIntegralDetailService sfaIntegralDetailService;
    @Resource
    private SfaIntegralMonthJobExecutor sfaIntegralMonthJobExecutor;
    @Resource
    private IntegralUserUtil integralUserUtil;

    @ApiOperation(value = "触发月度积分结算任务")
    @GetMapping("/integralDetailJob")
    @CrmLog
    public Result integralDetailJob(@RequestParam(required = false) String yearMonth){
        sfaIntegralMonthJobExecutor.integralDetailJob(yearMonth);
        return Result.ok();
    }

    /**
     * 积分明细报表-分页加模糊
     * @method pageDetail
     * @date: 2021/1/12 15:45
     * @author: YuanZiJian
     * @param sfaIntegralDetailReqVo
     * @return com.biz.crm.util.Result<com.biz.crm.common.PageResult<com.biz.crm.nebular.sfa.integral.resp.SfaIntegralDetailRespVo>>
     */
    @ApiOperation(value = "获得积分明细报表")
    @PostMapping("/pageDetail")
    @CrmDictMethod
    @CrmLog
    public Result<PageResult<SfaIntegralDetailRespVo>> integralDetailReport(@RequestBody  SfaIntegralDetailReqVo sfaIntegralDetailReqVo){
        return Result.ok(sfaIntegralDetailService.integralDetailReport(sfaIntegralDetailReqVo));
    }

    /**
     * 积分排名报表-分页加模糊
     * @method pageIntegralRank
     * @date: 2021/1/12 15:45
     * @author: YuanZiJian
     * @param sfaIntegralRankReqVo
     * @return com.biz.crm.util.Result<com.biz.crm.common.PageResult<com.biz.crm.nebular.sfa.integral.resp.SfaIntegralDetailRespVo>>
     */
    @ApiOperation(value = "获得积分排名报表")
    @PostMapping("/pageIntegralRank")
    @CrmLog
    public Result<PageResult<SfaIntegralRankRespVo>> pageIntegralRank(@RequestBody SfaIntegralRankReqVo sfaIntegralRankReqVo){
        return Result.ok(sfaIntegralDetailService.pageIntegralRank(sfaIntegralRankReqVo));
    }

    /**
     * 获得个人的积分明细-小程序端
     *
     * @method pageDetailByLoginUser
     * @date: 2021/1/15 12:37
     * @author: YuanZiJian
     * @param sfaIntegralDetailUserReqVo 必传page相关参数，userName选传
     * @return com.biz.crm.util.Result<com.biz.crm.common.PageResult<com.biz.crm.nebular.sfa.integral.resp.SfaIntegralDetailRespVo>>
     */
    @ApiOperation(value = "获得个人的积分明细-小程序端")
    @PostMapping("/pageDetailByLoginUser")
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<SfaIntegralDetailRespVo>> pageDetailByLoginUser(@RequestBody SfaIntegralDetailUserReqVo sfaIntegralDetailUserReqVo){
        return Result.ok(sfaIntegralDetailService.pageDetailByLoginUser(sfaIntegralDetailUserReqVo));
    }


    /**
     *
     * 查询登陆用户的总积分——小程序端
     * @method countIntegralNum
     * @date: 2021/1/15 12:38
     * @author: YuanZiJian
     * @return com.biz.crm.util.Result<com.biz.crm.nebular.sfa.integral.resp.SfaIntegralUserRankRespVo>
     */
    @ApiOperation(value = "获得登陆用户的总积分-小程序端")
    @PostMapping("/countIntegralNum")
    @CrmLog
    public Result<SfaIntegralUserRankRespVo> countIntegralNum(){
        UserRedis userRedis = UserUtils.getUser();
        return Result.ok(integralUserUtil.getObj(userRedis.getUsername()));
    }

    /**
     * 获得积分排名信息-小程序端
     * @method pageIntegralRankToApp
     * @date: 2021/1/15 14:47
     * @author: YuanZiJian
     * @param sfaIntegralRankAppReqVo 搜索条件——组织覆盖范围
     * @return com.biz.crm.util.Result<com.biz.crm.common.PageResult<com.biz.crm.nebular.sfa.integral.resp.SfaIntegralRankRespVo>>
     */
    @ApiOperation(value = "获得积分排名信息-小程序端")
    @PostMapping("/pageIntegralRankToApp")
    @CrmLog
    public Result<PageResult<SfaIntegralRankRespVo>> pageIntegralRankToApp(@RequestBody SfaIntegralRankAppReqVo sfaIntegralRankAppReqVo){
        return Result.ok(sfaIntegralDetailService.pageIntegralRankToApp(sfaIntegralRankAppReqVo));
    }


}
