package com.biz.crm.integral.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.integral.service.SfaIntegralRuleService;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.position.MdmPositionLevelFeign;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgTreeRespVo;
import com.biz.crm.nebular.mdm.positionlevel.req.MdmPositionLevelReqVo;
import com.biz.crm.nebular.sfa.integral.req.SfaIntegralRuleReqVo;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralRulePageRespVo;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralRuleRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 积分规则相关
 * @author YuanZiJian
 * @date 2021/1/11 14:44
 * @version: V1.0
 */
@Slf4j
@RestController
@RequestMapping("/sfaIntegralRule")
@Api(tags = "积分规则")
public class SfaIntegralRuleController {
    @Autowired
    SfaIntegralRuleService sfaIntegralRuleService;
    @Autowired
    MdmPositionLevelFeign mdmPositionLevelFeign;
    @Autowired
    MdmOrgFeign  mdmOrgFeign;

    /**
     * 职位等级下拉数据-无需传参
     * @return
     */
    @ApiOperation(value = "职位等级下拉")
    @PostMapping("/selectPosList")
    @CrmLog
    public Result selectPosList(@RequestBody MdmPositionLevelReqVo mdmPositionLevelReqVo){
        return mdmPositionLevelFeign.selectList(mdmPositionLevelReqVo);
    }


    /**
     * 组织树下拉数据-无需传参
     * @return
     */
    @ApiOperation(value = "组织树下拉数据")
    @PostMapping("/selectOrgList")
    @CrmLog
    public Result<List<MdmOrgTreeRespVo>> selectOrgList(){
        return mdmOrgFeign.orgSearchTree(new MdmOrgReqVo());
    }

    /**
     *
     * 新增积分规则
     * @method saveRule
     * @date: 2021/1/11 14:50
     * @author: YuanZiJian
     * @param sfaIntegralRuleReqVo
     * @return com.biz.crm.util.Result
     */
    @ApiOperation(value = "新增积分规则")
    @PostMapping("/saveRule")
    @CrmLog
    public Result saveRule(@RequestBody SfaIntegralRuleReqVo sfaIntegralRuleReqVo){
        sfaIntegralRuleService.saveIntegralRule(sfaIntegralRuleReqVo);
        return Result.ok();
    }

    /**
     *
     * 编辑积分规则
     * @method updateRule
     * @date: 2021/1/11 14:50
     * @author: YuanZiJian
     * @param sfaIntegralRuleReqVo
     * @return com.biz.crm.util.Result
     */
    @ApiOperation(value = "编辑积分规则")
    @PostMapping("/updateRule")
    @CrmLog
    public Result updateRule(@RequestBody SfaIntegralRuleReqVo sfaIntegralRuleReqVo){
        sfaIntegralRuleService.updateIntegralRule(sfaIntegralRuleReqVo);
        return Result.ok();
    }

    /**
     * 积分规则批量禁用
     * @method disableRule
     * @date: 2021/1/11 14:53
     * @author: YuanZiJian
     * @param ids——接收前端IDList
     * @return com.biz.crm.util.Result
     */
    @ApiOperation(value = "积分规则批量禁用")
    @PostMapping("/disableRule")
    @CrmLog
    public Result disableRule(@RequestBody List<String> ids){
        sfaIntegralRuleService.disableByIds(ids);
        return Result.ok();
    }

    /**
     * 积分规则批量启用
     * @method enableRule
     * @date: 2021/1/11 14:53
     * @author: YuanZiJian
     * @param ids——接收前端IDList
     * @return com.biz.crm.util.Result
     */
    @ApiOperation(value = "积分规则批量启用")
    @PostMapping("/enableRule")
    @CrmLog
    public Result enableRule(@RequestBody List<String> ids){
        sfaIntegralRuleService.enableByIds(ids);
        return Result.ok();
    }

    /**
     * 积分规则批量删除
     * @method deleteRule
     * @date: 2021/1/11 14:58
     * @author: YuanZiJian
     * @param ids——接收前端IDList
     * @return com.biz.crm.util.Result
     */
    @ApiOperation(value = "积分规则批量删除")
    @PostMapping("/deleteRule")
    @CrmLog
    public Result deleteRule(@RequestBody List<String> ids){
        sfaIntegralRuleService.deleteByIds(ids);
        return Result.ok();
    }


    /**
     * 积分规则根据Id获取规则信息
     * @method queryRule
     * @date: 2021/1/11 14:56
     * @author: YuanZiJian
     * @param id 积分规则Id
     * @return com.biz.crm.util.Result
     */
    @ApiOperation(value = "积分规则根据Id获取规则信息")
    @GetMapping("/queryRule")
    @CrmLog
    public Result queryRule(@RequestParam String id){
        return Result.ok(sfaIntegralRuleService.queryById(id));
    }

    /**
     * 积分规则获取规则信息列表
     * @method listRule
     * @date: 2021/1/11 19:21
     * @author: YuanZiJian
     * @param sfaIntegralRuleReqVo
     * @return com.biz.crm.common.PageResult<com.biz.crm.nebular.sfa.integral.resp.SfaIntegralRuleRespVo>
     */
    @ApiOperation(value = "积分规则获取规则信息列表")
    @PostMapping("/listRule")
    @CrmLog
    public Result<PageResult<SfaIntegralRulePageRespVo>> listRule(@RequestBody SfaIntegralRuleReqVo sfaIntegralRuleReqVo){
        return Result.ok(sfaIntegralRuleService.pageIntegralRule(sfaIntegralRuleReqVo));
    }


    @ApiOperation(value = "获取当前用户对应的积分规则的详情——小程序端")
    @PostMapping("/getTaskByLoginUser")
    @CrmLog
    public Result <SfaIntegralRuleRespVo> getTaskByLoginUser(){
        return Result.ok(sfaIntegralRuleService.getTaskByLoginUser());
    }





}
