package com.biz.crm.integral.controller;

import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.integral.req.SfaIntegralDetailAddReq;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.util.JsonPropertyUtil;
import lombok.extern.slf4j.Slf4j;


/**
 * 新增积分
 * @author yangshan
 * @date 2021/4/20 19:34
 */
@Slf4j
public class SfaIntegralSaveUtil {

    private static RocketMQProducer rocketMQProducer = SpringApplicationContextUtil.getApplicationContext().getBean(RocketMQProducer.class);

    /**
     * 定时任务，月度考勤结算和月度拜访积分结算
     * @param reqVo
     */
    public static void saveIntegralDetail(SfaIntegralDetailAddReq reqVo){
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTag(RocketMQConstant.CRM_MQ_TAG.INTEGRAL_DETAIL_TAG);
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonStringNotEmptyVal(reqVo));
        rocketMQProducer.convertAndSend(rocketMQMessageBody);
    }


}
