package com.biz.crm.integral.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.integral.model.SfaIntegralDetailEntity;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.sfa.integral.req.SfaIntegralDetailReqVo;
import com.biz.crm.nebular.sfa.integral.req.SfaIntegralRankReqVo;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralUserRankRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 积分明细实体 - mapper
 * @author YuanZiJian
 * @date 2021/1/12 10:02
 * @version: V1.0
 */
public interface SfaIntegralDetailMapper extends BaseMapper<SfaIntegralDetailEntity> {


    /**
     * 获取所有的积分明细实现分页和条件搜索
     * @method pageDetailNum
     * @date: 2021/1/15 10:35
     * @author: YuanZiJian
     * @param page
     * @param sfaIntegralRankReqVo
     * @return java.util.List<com.biz.crm.integral.model.SfaIntegralDetailEntity>
     */
    List<SfaIntegralDetailEntity> pageDetailNum(Page page , @Param("RankVo") SfaIntegralRankReqVo sfaIntegralRankReqVo);

    /**
     * 查询积分排名-全部(不分页）
     * @method countIntegralNumList
     * @date: 2021/1/15 10:36
     * @author: YuanZiJian
     * @return java.lang.Integer
     */
    List<SfaIntegralUserRankRespVo> listIntegralRank ();

    /**
     * 积分明细报表
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(orgCode = "t.org_code",posCode = "t.pos_code")
    List<SfaIntegralDetailEntity> integralDetailReport(Page<SfaIntegralDetailReqVo> page, @Param("vo") SfaIntegralDetailReqVo reqVo);


}
