package com.biz.crm.integral.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.integral.model.SfaIntegralRuleEntity;
import com.biz.crm.nebular.sfa.integral.req.SfaIntegralRuleReqVo;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralRulePageRespVo;
import com.biz.crm.nebular.sfa.integral.resp.SfaIntegralRuleRespVo;

import java.util.List;

/**
 * 积分规则表
 * @author YuanZiJian
 * @date 2021/1/8 14:03
 * @version: V1.0
 */
public interface SfaIntegralRuleService extends IService<SfaIntegralRuleEntity> {

    /**
     * 新增积分规则
     * @method saveIntegralRule
     * @date: 2021/1/8 14:24
     * @author: YuanZiJian
     * @param sfaIntegralRuleReqVo
     * @return void
     */
    void saveIntegralRule (SfaIntegralRuleReqVo sfaIntegralRuleReqVo);

    /**
     * 积分规则删除——物理删除
     * @method deleteIntegralRule
     * @date: 2021/1/8 16:37
     * @author: YuanZiJian
     * @param id 积分规则Id
     * @return void
     */
    void deleteIntegralRule(String id);

    /**
     *
     * 更新积分规则
     * @method updateIntegralRule
     * @date: 2021/1/8 16:42
     * @author: YuanZiJian
     * @param sfaIntegralRuleReqVo
     * @return void
     */
    void updateIntegralRule(SfaIntegralRuleReqVo sfaIntegralRuleReqVo);

    /**
     * 根据Id查询某个积分规则的详细信息
     * @method query
     * @date: 2021/1/8 17:34
     * @author: YuanZiJian
     * @param id 积分规则id
     * @return com.biz.crm.nebular.sfa.Integral.resp.SfaIntegralRuleRespVo
     */
    SfaIntegralRuleRespVo queryById (String id);

    /**
     * 根据条件查出所有的积分规则
     * 条件：积分规则Id、积分规则名称、覆盖的角色编码和角色名、覆盖的组织编码和组织名
     * 分页实现
     * @method pageIntegralRule
     * @date: 2021/1/11 11:11
     * @author: YuanZiJian
     * @param sfaIntegralRuleReqVo
     * @return com.biz.crm.common.PageResult<com.biz.crm.nebular.sfa.Integral.resp.SfaIntegralRuleRespVo>
     */
    PageResult<SfaIntegralRulePageRespVo> pageIntegralRule(SfaIntegralRuleReqVo sfaIntegralRuleReqVo);

    /**
     * 根据传入ID列表批量删除
     * @method deleteByIds
     * @date: 2021/1/11 10:38
     * @author: YuanZiJian
     * @param ids 积分规则的Id集合
     * @return void
     */
    void deleteByIds(List<String> ids);

    /**
     * 根据传入ID列表批量启用
     * @method enableByIds
     * @date: 2021/1/11 10:39
     * @author: YuanZiJian
     * @param ids 积分规则的Id集合
     * @return void
     */
    void enableByIds(List<String> ids);

    /**
     * 根据传入ID列表批量禁用
     * @method disableByIds
     * @date: 2021/1/11 10:40
     * @author: YuanZiJian
     * @param ids 积分规则的id集合
     * @return void
     */
    void disableByIds(List<String> ids);

    /**
     * 获取当前用户对应的积分计算规则
     * @method getTaskByUserName
     * @date: 2021/1/15 9:59
     * @author: YuanZiJian
     * @return com.biz.crm.nebular.sfa.integral.resp.SfaIntegralRuleRespVo
     */
    SfaIntegralRuleRespVo getTaskByLoginUser();
}
