package com.biz.crm.integral.service.component;

import com.biz.crm.eunm.mdm.SourceType;
import com.biz.crm.eunm.sfa.IntegralEnum;
import com.biz.crm.integral.req.SfaIntegralDetailAddReq;
import com.biz.crm.integral.service.SfaIntegralDetailService;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.JsonPropertyUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;


/**
 *  @author: luoqi
 *  @Date: 2021-5-24 14:56
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = "${rocketmq.topic}" + "${rocketmq.environment-variable}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag定义在 RocketMQConstant.CRM_MQ_TAG 内统一维护
        */
        selectorExpression = RocketMQConstant.CRM_MQ_TAG.TERMINAL_NEW_OR_PASS,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup定义在 RocketMQConstant.CONSUMER_GROUP 内统一维护
        */
        consumerGroup = RocketMQConstant.CONSUMER_GROUP.TERMINAL_NEW_OR_PASS + "${rocketmq.environment-variable}")
public class SfaIntegralDetailClientCreatedMQConsumer extends AbstractRocketMQConsumer {
    /**
     * 如果是集群部署，则通过该配置来限制集群内至多只有一台服务会执行该逻辑
     */
    @Value("${job.runScheduledTask:false}")
    private Boolean runScheduledTask;
    @Resource
    private SfaIntegralDetailService sfaIntegralDetailService;
    /**
     * 消费消息
     *
     * @param message
     * @return
     */
    @Override
    protected Object handleMessage(RocketMQMessageBody message) {
        if(this.runScheduledTask){
            String msg = message.getMsgBody();
            if(StringUtils.isEmpty(msg)){
                return "消息体为空!";
            }
            MdmTerminalVo mdmTerminalVo = JsonPropertyUtil.toObject(msg, MdmTerminalVo.class);
            if(null == mdmTerminalVo){
                return "序列化消息体失败!";
            }
            String sourceType = mdmTerminalVo.getSourceType();
            if(SourceType.WE_CHAT_APP.getValue().equals(sourceType)
                    || SourceType.ANDROID.getValue().equals(sourceType)
                    || SourceType.IOS.getValue().equals(sourceType)){
                //增加积分
                SfaIntegralDetailAddReq integralDetailAddReq = new SfaIntegralDetailAddReq();
                integralDetailAddReq.setBizId(mdmTerminalVo.getId());
                integralDetailAddReq.setIntegralTaskType(IntegralEnum.taskType.SAVE_TERMINAL.getValue());
                integralDetailAddReq.setPosCode(mdmTerminalVo.getCreatePosCode());
                integralDetailAddReq.setUserName(mdmTerminalVo.getCreateName());
                this.sfaIntegralDetailService.integralDetailAdd(integralDetailAddReq);
                return "操作成功";
            }else{
                return "sourceType = " + sourceType;
            }


        }
        return "runScheduledTask = false";
    }




}
