package com.biz.crm.integral.service.component;

import com.biz.crm.integral.req.SfaIntegralDetailAddReq;
import com.biz.crm.integral.service.SfaIntegralDetailService;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.util.JsonPropertyUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;

/**
 * @author yangshan
 * @date 2021/4/21 17:26
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = "${rocketmq.topic}" + "${rocketmq.environment-variable}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag定义在 RocketMQConstant.CRM_MQ_TAG 内统一维护
        */
        selectorExpression = RocketMQConstant.CRM_MQ_TAG.INTEGRAL_DETAIL_TAG,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup定义在 RocketMQConstant.CONSUMER_GROUP 内统一维护
        */
        consumerGroup = RocketMQConstant.CONSUMER_GROUP.INTEGRAL_DETAIL + "${rocketmq.environment-variable}")
public class SfaIntegralDetailMQConsumer extends AbstractRocketMQConsumer {

    @Resource
    private SfaIntegralDetailService sfaIntegralDetailService;
    /**
     * 消费消息
     *
     * @param message
     * @return
     */
    @Override
    protected Object handleMessage(RocketMQMessageBody message) {
        String msg = message.getMsgBody();
        if(StringUtils.isEmpty(msg)){
            return "消息体为空!";
        }
        SfaIntegralDetailAddReq req = JsonPropertyUtil.toObject(msg, SfaIntegralDetailAddReq.class);
        if(null == req){
            return "序列化消息体失败!";
        }

        sfaIntegralDetailService.integralDetailAdd(req);
        return "操作成功";
    }




}
