package com.biz.crm.job;

import com.biz.crm.assistant.service.ISfaWorkTaskReleaseService;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDate;

/**
 * 任务过期定时任务
 *
 * @Author hej
 * @Created Date 2020-11-20
 **/

@Slf4j
@Component
public class SfaWorkTaskReceveJob {

    @Resource
    private ISfaWorkTaskReleaseService sfaWorkTaskReleaseService;


    /**
     * 凌晨一点执行
     */
//    @Scheduled(cron = "*/10 * * * * ?")
    public void executeWorkSignRule() {

        log.warn("#########################任务过期策略开始#########################");
        UserUtils.doTokenForNull();
        sfaWorkTaskReleaseService.timeExpiredTask(LocalDate.now().format(CrmDateUtils.yyyyMMdd));
        log.warn("#########################任务过期策略结束#########################");


    }

}
