package com.biz.crm.job;


import com.biz.crm.visitinfo.service.ISfaVisitCompleteInfoService;
import com.biz.crm.visitinfo.service.impl.VisitPlanInfoHelper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Slf4j
@Component
public class VisitPlanInfoSettlementJob {
    @Resource
    protected ISfaVisitCompleteInfoService sfaVisitCompleteInfoService;
    @Resource
    private VisitPlanInfoHelper helper;


    /**
     * 拜访计划结算任务
     * 每天0点30分执行任务
     */
    public void doJob() {

        log.warn("#######################拜访计划结算任务开始####################");
        this.helper.planInfoSettlementForJob(null);
        log.warn("#######################拜访计划结算任务结束####################");
    }

    /**
     * 拜访日进度结算任务开始
     * 每天5点30分执行任务
     */
    public void planInfoSettlementForJob() {

        log.warn("#######################拜访日进度结算任务开始####################");
        this.sfaVisitCompleteInfoService.planInfoSettlementForJob(null);
        log.warn("#######################拜访日进度结算任务结束####################");
    }
}
