package com.biz.crm.job.controller;

import com.biz.crm.job.*;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.job.controller
 * @date 2021/7/30 14:32
 */
@Api(tags = "sfa的定时任务")
@Slf4j
@RestController
@RequestMapping("sfaJobController")
public class SfaJobController {

    @Resource
    private VisitPlanInfoSettlementJob visitPlanInfoSettlementJob;
    @Resource
    private SfaWorkTaskReceveJob sfaWorkTaskReceveJob;
    @Resource
    private SfaIntegralDetailJob sfaIntegralDetailJob;
    @Resource
    private ResolveSfaVisitStepActivityExecutionJob sfaVisitStepActivityExecutionJob;
    @Resource
    private SfaVisitDealerJob sfaVisitDealerJob;


    /**
     * 拜访计划结算任务
     * 每天0点30分执行任务
     *
     * @Scheduled(cron = "0 30 0 * * ?")
     */
    @ApiOperation(value = "拜访计划结算任务")
    @GetMapping("visitPlanInfoSettlementDoJob")
    public Result visitPlanInfoSettlementDoJob() {
        this.visitPlanInfoSettlementJob.doJob();
        return Result.ok();
    }


    /**
     * 拜访日进度结算任务开始
     * 每天5点30分执行任务
     *
     * @Scheduled(cron = "0 30 5 * * ?")
     */
    @ApiOperation(value = "拜访日进度结算任务开始")
    @GetMapping("planInfoSettlementForJob")
    public Result planInfoSettlementForJob() {
        this.visitPlanInfoSettlementJob.planInfoSettlementForJob();
        return Result.ok();
    }


    /**
     * 任务过期定时任务
     * 凌晨一点执行
     *
     * @return
     * @Scheduled(cron = "0 0 1 * * ?")
     */
    @ApiOperation(value = "任务过期定时任务")
    @GetMapping("executeWorkSignRule")
    public Result executeWorkSignRule() {
        sfaWorkTaskReceveJob.executeWorkSignRule();
        return Result.ok();
    }


    /**
     * 月度拜访计划完成时执行
     *
     * @return
     * @Scheduled(cron = "0 30 0 2 * ?")
     */
    @ApiOperation(value = "每月定时拉取职位增加积分")
    @GetMapping("saveIntegralDetailByMonth")
    public Result saveIntegralDetailByMonth() {
        sfaIntegralDetailJob.saveIntegralDetailByMonth();
        return Result.ok();
    }


    /**
     * 活动执行明细解析任务 每天3点30分执行任务
     *
     * @return
     */
    @ApiOperation(value = "活动明细任务解析")
    @GetMapping("resolveSfaVisitActivityExecute")
    public Result resolveSfaVisitActivityExecute() {
        sfaVisitStepActivityExecutionJob.doJob();
        return Result.ok();
    }


    @ApiOperation(value = "解析拜访计划明细")
    @GetMapping("executeSfaVisitPlan")
    public Result executeSfaVisitPlan() {
        sfaVisitDealerJob.executeSfaVisitPlan();
        return Result.ok();
    }
}
