package com.biz.crm.map.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.map.mapper.SfaTencentMapDataMapper;
import com.biz.crm.map.model.SfaTencentMapDataEntity;
import com.biz.crm.map.model.req.SfaCoordinatesDetermineReqVO;
import com.biz.crm.map.model.req.SfaSalesFenceReqVO;
import com.biz.crm.map.model.req.SfaTencentMapData;
import com.biz.crm.map.model.resp.SfaTencentMapDataRespVo;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.terminal.MdmTencentMapData;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.CopyUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author yangshan
 * @date 2021/4/14 21:24
 */
@Slf4j
@Service
@Transactional
public class SfaTencentMapDataServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<SfaTencentMapDataMapper, SfaTencentMapDataEntity> implements SfaTencentMapDataService {
    @Resource
    private SfaTencentMapDataMapper sfaTencentMapDataMapper;

    @Resource
    private MdmTerminalFeign mdmTerminalFeign;

    @Value("${tencent.a-fence}")
    private String coordinatesDetermine;
    @Value("${tencent.sales-fence}")
    private String  salesFence;
    @Value("${tencent.key}")
    private String key;

    /**
     * 新增
     *
     * @param reqVo
     */
    @Override
    public void save(List<SfaTencentMapDataEntity> reqVo) {
        HashSet<SfaTencentMapDataEntity> data = new HashSet<>();
        reqVo.forEach(o -> {
            if (StringUtils.isEmpty(o.getMapId())
                    || StringUtils.isEmpty(o.getLongitude())
                    || StringUtils.isEmpty(o.getLatitude())
                    || StringUtils.isEmpty(o.getName())){
                return;
            }
            data.add(o);
        });
        ArrayList<SfaTencentMapDataEntity> entities = Lists.newArrayList(data);
        List<String> idList = entities.stream().map(SfaTencentMapDataEntity::getMapId).collect(Collectors.toList());
        this.lambdaUpdate().in(SfaTencentMapDataEntity::getMapId, idList).remove();
        List<SfaTencentMapDataEntity> sfaTencentMapDataEntities = CrmBeanUtil.copyList(entities, SfaTencentMapDataEntity.class);
        this.saveBatch(sfaTencentMapDataEntities);

    }

    @Override
    public Result saveTxMapData(SfaTencentMapData sfaTencentMapData) {
        List<SfaTencentMapData.SfaTencentMapDataReqVo> data = sfaTencentMapData.getData();
        MdmTencentMapData mdmTencentMapData = new MdmTencentMapData();
        List<MdmTencentMapData.MdmTencentMapDataReqVo> mdm = new ArrayList<>();
        for (SfaTencentMapData.SfaTencentMapDataReqVo datum : data) {
            MdmTencentMapData.MdmTencentMapDataReqVo toData = new MdmTencentMapData.MdmTencentMapDataReqVo();
            BeanUtils.copyProperties(datum,toData);
            mdm.add(toData);
        }
        mdmTencentMapData.setData(mdm);
        return mdmTerminalFeign.saveTxBatch(mdmTencentMapData);
    }


    /**
     * 分页查询
     *
     * @param reqVo
     */
    @Override
    public PageResult<SfaTencentMapDataRespVo> findList(SfaTencentMapData.SfaTencentMapDataReqVo reqVo) {
        Page<SfaTencentMapDataRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<SfaTencentMapDataRespVo> result = sfaTencentMapDataMapper.findList(page, reqVo);
        return PageResult.<SfaTencentMapDataRespVo>builder()
                .count(page.getTotal())
                .data(result)
                .build();
    }

    @Override
    public Result qrySalesConsultantFence(SfaCoordinatesDetermineReqVO reqVO) {
        reqVO.setCity(reqVO.getCity());
        reqVO.setDistrict(reqVO.getDistrict());
        reqVO.setProvince(reqVO.getProvince());
        SfaCoordinatesDetermineReqVO.Location location = new SfaCoordinatesDetermineReqVO.Location();
        location.setLat(reqVO.getLocation().getLat());
        location.setLng(reqVO.getLocation().getLng());
        reqVO.setLocation(location);
        reqVO.setKey(key);
        JSONObject jsonObject = postForObject(RestTemplateUtils.geTemplate(), coordinatesDetermine, JSON.parseObject(JSON.toJSONString(reqVO)), JSONObject.class, null);
        if(Objects.isNull(jsonObject)){
            return Result.error("tencent接口返回数据为空");
        }
        JSONObject data = jsonObject.getJSONObject("data");
        data = data == null? new JSONObject():data;
        //线下销售
        String salesConsultantOffline = data.getString("salesConsultantOffline");
        if(StringUtils.isNotEmpty(salesConsultantOffline) && salesConsultantOffline.equals(reqVO.getSalesConsultantOffline())){
            return Result.ok();
        }
        return Result.error("当前终端网点未在你的所属片区，无法进行拜访！");
    }

    @Override
    public Result<List<String>> qrySalesFence(SfaSalesFenceReqVO reqVO) {
        reqVO.setKey(key);
        JSONObject jsonObject = postForObject(RestTemplateUtils.geTemplate(), salesFence, JSON.parseObject(JSON.toJSONString(reqVO)), JSONObject.class, null);
        List<String> list = Lists.newArrayList();
        if(Objects.isNull(jsonObject)){
            return Result.ok(list);
        }
        JSONObject data = jsonObject.getJSONObject("data");
        data = data == null? new JSONObject():data;
        //线下销售
        //eq:"121.4398727,31.2236379;121.4434776,31.2249254;121.4563951,31.2242816;121.4526186,31.2196039;121.445323,31.2149261;121.4375553,31.2194322;121.4398727,31.2236379"
        String fence = data.getString("fence");
        fence = fence.replace("|",";");
        String[] split = fence.split(";");
        for (int i = 0; i < split.length; i++) {
            list.add(split[i]);
        }
        return Result.ok(list);
    }




    /**
     * post请求
     *
     * @param restTemplate restTemplate
     * @param url          请求路径
     * @param jsonObject   body数据
     * @param responseType 返回类型
     * @param params       参数
     * @param <T>          结果泛型
     * @return T
     */
    public static <T> T postForObject(RestTemplate restTemplate, String url, JSONObject jsonObject
            , Class<T> responseType, Map<String, Object> params) {
        if (MapUtils.isNotEmpty(params)) {
            List<String> uriParams = params.keySet().stream().map(s -> s + "={" + s + "}").collect(Collectors.toList());
            url += "?" + org.apache.commons.lang3.StringUtils.join(uriParams, "&");
        }
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        HttpEntity<String> httpEntity = new HttpEntity<>(jsonObject == null ? null : jsonObject.toJSONString(), headers);

        if (MapUtils.isNotEmpty(params)) {
            return restTemplate.postForObject(url, httpEntity, responseType, params);
        }
        return restTemplate.postForObject(url, httpEntity, responseType);
    }



}
