package com.biz.crm.moblie.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.moblie.service.SfaApprovalService;
import com.biz.crm.nebular.sfa.approval.req.SfaApprovalListReqVo;
import com.biz.crm.nebular.sfa.approval.resp.SfaApprovalListRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 小程序端——我的审批相关接口
 * @author YuanZiJian
 * @date 2021/3/10 15:11
 * @version: V1.0
 */
@Slf4j
@RestController
@RequestMapping("/sfaApproval")
@Api(tags = "小程序端——我的审批")
public class SfaApprovalController {
    @Resource
    SfaApprovalService sfaApprovalService;

    @ApiOperation(value = "查询登陆人的SFA待办已办流程列表")
    @PostMapping("/getApprovalList")
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<SfaApprovalListRespVo>> getApprovalList(@RequestBody  SfaApprovalListReqVo sfaApprovalListReqVo){
        PageResult<SfaApprovalListRespVo> approvalList = sfaApprovalService.getApprovalList(sfaApprovalListReqVo);
        return Result.ok(approvalList);
    }


    @ApiOperation(value = "查询抄送的未读信息")
    @PostMapping("/countSend")
    @CrmLog
    public Result countSend(){
        return sfaApprovalService.countSend();
    }

}
