package com.biz.crm.moblie.controller;

import com.biz.crm.checkin.service.ISfaCheckInSignRecordService;
import com.biz.crm.nebular.mdm.PageVo;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInSignRecordReqVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInGroupRespVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInSignRecordRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaSignHistoryListReqVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.aop.CrmLog;

/**
 * 签到组-签到图片
 *
 * @author fily
 * @date 2021-01-05 13:12:39
 */
@Slf4j
@RestController
@RequestMapping("/sfacheckinsigngroup")
@Api(tags = "小程序-工作台-自由签到(签到组)")
public class SfaCheckInSignGroupController {
    @Autowired
    private ISfaCheckInSignRecordService iSfaCheckInSignRecordService;

    @ApiOperation(value = "我的签到组列表")
    @PostMapping("/myCheckInGroup")
    @CrmLog
    public Result<PageResult<SfaCheckInGroupRespVo>> myCheckInGroup(@RequestBody PageVo pageVo) {

        return Result.ok(iSfaCheckInSignRecordService.myCheckInGroup(pageVo));
    }

    @ApiOperation(value = "自由签到")
    @PostMapping("/checkInGroupSign")
    @CrmLog
    public Result checkInGroupSign(@RequestBody SfaCheckInSignRecordReqVo reqVo) {

        iSfaCheckInSignRecordService.checkInGroupSign(reqVo);
        return Result.ok();
    }

    @ApiOperation("考勤历史")
    @PostMapping("/signHistoryList")
    @CrmLog
    public Result<PageResult<SfaCheckInSignRecordRespVo>> signHistoryList(@RequestBody SfaSignHistoryListReqVo reqVo) {

        return Result.ok(iSfaCheckInSignRecordService.findList(reqVo));
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<SfaCheckInSignRecordRespVo> query(@RequestParam(value = "id" , required = false) String id) {
        SfaCheckInSignRecordRespVo respVo= iSfaCheckInSignRecordService.query(id);
        return Result.ok(respVo);
    }

}
