package com.biz.crm.moblie.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.moblie.controller.visit.resp.SfaVisitResp;
import com.biz.crm.moblie.service.ISfaNearbyCustomerService;
import com.biz.crm.nebular.sfa.moblie.req.SfaNearbyCustomerReqVo;
import com.biz.crm.nebular.sfa.moblie.resp.SfaNearbyCustomerRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 附近客户
 * @author yangshan
 * @date 2021/3/9 14:32
 */
@RestController
@RequestMapping("/sfaNearbyCustomerController")
@Slf4j
@Api(tags = "附近客户")
public class SfaNearbyCustomerController {

    @Autowired
    private ISfaNearbyCustomerService sfaNearbyCustomerService;

    @ApiOperation(value = "根据经纬度查询未合作客户")
    @PostMapping("/findNotCooperationCustomerList")
    @CrmLog
    public Result<SfaVisitResp> findNotCooperationCustomerList(@RequestBody SfaNearbyCustomerReqVo reqVo){
        return Result.ok(sfaNearbyCustomerService.findNotCooperationCustomerList(reqVo));
    }

    @ApiOperation(value = "根据经纬度查询已合作客户")
    @PostMapping("/findCooperationCustomerList")
    @CrmLog
    public Result<SfaVisitResp> findCooperationCustomerList(@RequestBody SfaNearbyCustomerReqVo reqVo){
        return Result.ok(sfaNearbyCustomerService.findCooperationCustomerList(reqVo));
    }
}
